/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployer.Deployer;

public final class RemoteDeployer
implements Deployer {
    private static final Logger LOGGER = Logger.getLogger(RemoteDeployer.class);
    private static final int DEFAULT_PORT = 9990;
    private static final String JBWS_DEPLOYER_HOST = "jbossws.deployer.host";
    private static final String JBWS_DEPLOYER_PORT = "jbossws.deployer.port";
    private static final String JBWS_DEPLOYER_PROTOCOL = "jbossws.deployer.protocol";
    private static final String JBWS_DEPLOYER_AUTH_USER = "jbossws.deployer.authentication.username";
    private static final String JBWS_DEPLOYER_AUTH_PWD = "jbossws.deployer.authentication.password";
    private static final String JBWS_DEPLOYER_HTTPS_LISTENER_NAME = "jbws-test-https-listener";
    private static final String JBWS_DEPLOYER_HTTPS_LISTENER_REALM_NAME = "jbws-test-https-realm";
    private static final CallbackHandler callbackHandler = RemoteDeployer.getCallbackHandler();
    private static final int TIMEOUT = 60000;
    private static InetAddress address;
    private static Integer port;
    private static String protocol;
    private final Map<URL, String> url2Id = new HashMap<URL, String>();
    private final Map<String, Integer> securityDomainUsers = new HashMap<String, Integer>(1);
    private final Map<String, Integer> archiveCounters = new HashMap<String, Integer>();
    private final Semaphore httpsConnSemaphore = new Semaphore(1);
    private static final String SERVER_IDENTITY_SSL = "server-identity.ssl.";
    private static final String AUTHENTICATION_TRUSTORE = "authentication.truststore.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(URL archiveURL) throws Exception {
        Map<String, Integer> map = this.archiveCounters;
        synchronized (map) {
            String k = archiveURL.toString();
            if (this.archiveCounters.containsKey(k)) {
                int count = this.archiveCounters.get(k);
                this.archiveCounters.put(k, count + 1);
                return;
            }
            this.archiveCounters.put(k, 1);
            ModelControllerClient client = RemoteDeployer.newModelControllerClient();
            ServerDeploymentManager deploymentManager = RemoteDeployer.newDeploymentManager(client);
            DeploymentPlanBuilder builder = deploymentManager.newDeploymentPlan().add(archiveURL).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction deployAction = builder.getLastAction();
            String uniqueId = deployAction.getDeploymentUnitUniqueName();
            this.executeDeploymentPlan(plan, deployAction, client, deploymentManager);
            this.url2Id.put(archiveURL, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URL archiveURL) throws Exception {
        Map<String, Integer> map = this.archiveCounters;
        synchronized (map) {
            String k = archiveURL.toString();
            if (this.archiveCounters.containsKey(k)) {
                int count = this.archiveCounters.get(k);
                if (count > 1) {
                    this.archiveCounters.put(k, count - 1);
                    return;
                }
            } else {
                LOGGER.warn((Object)("Trying to undeploy archive " + archiveURL + " which is not currently deployed!"));
                return;
            }
            this.archiveCounters.remove(k);
            String uniqueName = this.url2Id.get(archiveURL);
            if (uniqueName != null) {
                ModelControllerClient client = RemoteDeployer.newModelControllerClient();
                ServerDeploymentManager deploymentManager = RemoteDeployer.newDeploymentManager(client);
                InitialDeploymentPlanBuilder builder = deploymentManager.newDeploymentPlan();
                DeploymentPlan plan = builder.undeploy(uniqueName).remove(uniqueName).build();
                DeploymentAction deployAction = builder.getLastAction();
                try {
                    this.executeDeploymentPlan(plan, deployAction, client, deploymentManager);
                }
                finally {
                    this.url2Id.remove(archiveURL);
                }
            }
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction, ModelControllerClient client, ServerDeploymentManager deploymentManager) throws Exception {
        try {
            Exception deploymentException;
            ServerDeploymentActionResult actionResult;
            ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)deploymentManager.execute(plan).get();
            if (deployAction != null && (actionResult = planResult.getDeploymentActionResult(deployAction.getId())) != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
                throw deploymentException;
            }
        }
        catch (Exception e) {
            LOGGER.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            client.close();
            deploymentManager.close();
        }
    }

    public String getServerVersion() throws Exception {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-attribute");
        request.get("address").setEmptyList();
        request.get("name").set("release-version");
        ModelNode response = RemoteDeployer.applyUpdate(request);
        return response.get("result").asString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            if (this.securityDomainUsers.containsKey(name)) {
                int count = this.securityDomainUsers.get(name);
                this.securityDomainUsers.put(name, count + 1);
                return;
            }
            this.securityDomainUsers.put(name, 1);
            ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
            ModelNode compositeOp = new ModelNode();
            compositeOp.get("operation").set("composite");
            compositeOp.get("address").setEmptyList();
            compositeOp.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            ModelNode steps = compositeOp.get("steps");
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "security").append("security-domain", name);
            steps.add(Util.createAddOperation((PathAddress)address));
            address = address.append("authentication", "classic");
            steps.add(Util.createAddOperation((PathAddress)address));
            ModelNode loginModule = Util.createAddOperation((PathAddress)address.append("login-module", "UsersRoles"));
            loginModule.get("code").set("UsersRoles");
            loginModule.get("flag").set("required");
            loginModule.get("operation-headers").get("allow-resource-service-restart").set(true);
            ModelNode moduleOptions = loginModule.get("module-options");
            if (authenticationOptions != null) {
                for (String k : authenticationOptions.keySet()) {
                    moduleOptions.add(k, authenticationOptions.get(k));
                }
            }
            steps.add(loginModule);
            updates.add(compositeOp);
            RemoteDeployer.applyUpdates(updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJaspiSecurityDomain(String name, String loginModuleStackName, Map<String, String> loginModuleOptions, String authModuleName, Map<String, String> authModuleOptions) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            if (this.securityDomainUsers.containsKey(name)) {
                int count = this.securityDomainUsers.get(name);
                this.securityDomainUsers.put(name, count + 1);
                return;
            }
            this.securityDomainUsers.put(name, 1);
            ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
            ModelNode compositeOp = new ModelNode();
            compositeOp.get("operation").set("composite");
            compositeOp.get("address").setEmptyList();
            compositeOp.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            ModelNode steps = compositeOp.get("steps");
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "security").append("security-domain", name);
            steps.add(Util.createAddOperation((PathAddress)address));
            PathAddress parentAddress = address.append("authentication", "jaspi");
            steps.add(Util.createAddOperation((PathAddress)parentAddress));
            PathAddress loignStackAddress = parentAddress.append("login-module-stack", loginModuleStackName);
            ModelNode loginStack = Util.createAddOperation((PathAddress)loignStackAddress);
            steps.add(loginStack);
            ModelNode loginModule = Util.createAddOperation((PathAddress)loignStackAddress.append("login-module", "UsersRoles"));
            loginModule.get("code").set("UsersRoles");
            loginModule.get("flag").set("required");
            loginModule.get("operation-headers").get("allow-resource-service-restart").set(true);
            ModelNode moduleOptions = loginModule.get("module-options");
            if (loginModuleOptions != null) {
                for (String k : loginModuleOptions.keySet()) {
                    moduleOptions.add(k, loginModuleOptions.get(k));
                }
            }
            steps.add(loginModule);
            PathAddress authModule = parentAddress.append("auth-module", authModuleName);
            ModelNode authModuleNode = Util.createAddOperation((PathAddress)authModule);
            authModuleNode.get("login-module-stack-ref").set(loginModuleStackName);
            authModuleNode.get("code").set(authModuleName);
            ModelNode options = authModuleNode.get("module-options");
            if (authModuleOptions != null) {
                for (String k : authModuleOptions.keySet()) {
                    options.add(k, authModuleOptions.get(k));
                }
            }
            steps.add(authModuleNode);
            updates.add(compositeOp);
            RemoteDeployer.applyUpdates(updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityDomain(String name) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            int count = this.securityDomainUsers.get(name);
            if (count > 1) {
                this.securityDomainUsers.put(name, count - 1);
                return;
            }
            this.securityDomainUsers.remove(name);
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", name);
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            RemoteDeployer.applyUpdate(op);
        }
    }

    public void addHttpsConnector(Map<String, String> options) throws Exception {
        HashMap<String, String> sslOptionsMap = new HashMap<String, String>();
        HashMap<String, String> truststoreOptionsMap = new HashMap<String, String>();
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key;
                String k = entry.getKey();
                if (k.startsWith(SERVER_IDENTITY_SSL)) {
                    key = k.substring(SERVER_IDENTITY_SSL.length());
                    sslOptionsMap.put(key, entry.getValue());
                    continue;
                }
                if (!k.startsWith(AUTHENTICATION_TRUSTORE)) continue;
                key = k.substring(AUTHENTICATION_TRUSTORE.length());
                truststoreOptionsMap.put(key, entry.getValue());
            }
        }
        this.httpsConnSemaphore.acquire();
        try {
            RemoteDeployer.addSecurityRealm(JBWS_DEPLOYER_HTTPS_LISTENER_REALM_NAME, sslOptionsMap, truststoreOptionsMap);
            ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
            ModelNode steps = composite.get("steps");
            ModelNode op = RemoteDeployer.createOpNode("subsystem=undertow/server=default-server/https-listener=jbws-test-https-listener", "add");
            op.get("socket-binding").set("https");
            op.get("security-realm").set(JBWS_DEPLOYER_HTTPS_LISTENER_REALM_NAME);
            String verifyClient = "verify-client";
            if (options != null && options.containsKey("verify-client")) {
                op.get("verify-client").set(options.get("verify-client"));
            }
            steps.add(op);
            RemoteDeployer.applyUpdate(composite);
        }
        catch (Exception e) {
            this.httpsConnSemaphore.release();
            throw e;
        }
    }

    private static void addSecurityRealm(String realm, Map<String, String> sslOptions, Map<String, String> truststoreOptions) throws Exception {
        ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = composite.get("steps");
        ModelNode op = RemoteDeployer.createOpNode("core-service=management/security-realm=" + realm, "add");
        steps.add(op);
        if (!sslOptions.isEmpty()) {
            ModelNode ssl = RemoteDeployer.createOpNode("core-service=management/security-realm=" + realm + "/server-identity=ssl", "add");
            for (Map.Entry<String, String> entry : sslOptions.entrySet()) {
                ssl.get(entry.getKey()).set(entry.getValue());
            }
            steps.add(ssl);
        }
        if (!truststoreOptions.isEmpty()) {
            ModelNode truststore = RemoteDeployer.createOpNode("core-service=management/security-realm=" + realm + "/authentication=truststore", "add");
            for (Map.Entry<String, String> entry : truststoreOptions.entrySet()) {
                truststore.get(entry.getKey()).set(entry.getValue());
            }
            steps.add(truststore);
        }
        RemoteDeployer.applyUpdate(composite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpsConnector() throws Exception {
        try {
            ModelNode op = RemoteDeployer.createOpNode("subsystem=undertow/server=default-server/https-listener=jbws-test-https-listener", "remove");
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            RemoteDeployer.applyUpdate(op);
            op = RemoteDeployer.createOpNode("core-service=management/security-realm=jbws-test-https-realm", "remove");
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            RemoteDeployer.applyUpdate(op);
        }
        finally {
            this.httpsConnSemaphore.release();
        }
    }

    public String setSystemProperty(String propName, String propValue) throws Exception {
        String previousValue;
        ModelNode op;
        block5: {
            if (propName == null || propName.trim().length() == 0) {
                throw new IllegalArgumentException("Empty system property name specified!");
            }
            op = RemoteDeployer.createOpNode("system-property=" + propName, "read-resource");
            previousValue = null;
            try {
                ModelNode response = RemoteDeployer.applyUpdate(op);
                String rawResult = response.get("result").asString();
                previousValue = rawResult.substring(13, rawResult.length() - 2);
            }
            catch (Exception e) {
                if (e.getMessage().contains("WFLYCTL0216")) break block5;
                throw e;
            }
        }
        if (previousValue != null) {
            op = RemoteDeployer.createOpNode("system-property=" + propName, "remove");
            RemoteDeployer.applyUpdate(op);
        }
        if (propValue != null) {
            op = RemoteDeployer.createOpNode("system-property=" + propName, "add");
            op.get("value").set(propValue);
            RemoteDeployer.applyUpdate(op);
        }
        return previousValue;
    }

    private static void applyUpdates(List<ModelNode> updates) throws Exception {
        for (ModelNode update : updates) {
            RemoteDeployer.applyUpdate(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModelNode applyUpdate(ModelNode update) throws Exception {
        try (ModelControllerClient client = RemoteDeployer.newModelControllerClient();){
            ModelNode result = client.execute(new OperationBuilder(update).build());
            RemoteDeployer.checkResult(result);
            ModelNode modelNode = result;
            return modelNode;
        }
    }

    private static void checkResult(ModelNode result) throws Exception {
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                LOGGER.info((Object)result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new Exception(result.get("failure-description").toString());
            }
            throw new Exception("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    private static CallbackHandler getCallbackHandler() {
        final String username = RemoteDeployer.getSystemProperty(JBWS_DEPLOYER_AUTH_USER, null);
        if (username == null || "${jbossws.deployer.authentication.username}".equals(username)) {
            return null;
        }
        String pwd = RemoteDeployer.getSystemProperty(JBWS_DEPLOYER_AUTH_PWD, null);
        if ("${jbossws.deployer.authentication.password}".equals(pwd)) {
            pwd = null;
        }
        final String password = pwd;
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) continue;
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
    }

    public static ModelNode createOpNode(String address, String operation) {
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        op.get("operation").set(operation);
        return op;
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return AccessController.doPrivileged(action);
    }

    private static ModelControllerClient newModelControllerClient() throws Exception {
        return ModelControllerClient.Factory.create((String)protocol, (String)address.getHostAddress(), (int)port, (CallbackHandler)callbackHandler, null, (int)60000);
    }

    private static ServerDeploymentManager newDeploymentManager(ModelControllerClient client) throws Exception {
        return ServerDeploymentManager.Factory.create((ModelControllerClient)client);
    }

    static {
        try {
            String host = System.getProperty(JBWS_DEPLOYER_HOST);
            address = host != null ? InetAddress.getByName(host) : InetAddress.getByName("localhost");
            port = Integer.getInteger(JBWS_DEPLOYER_PORT, 9990);
            protocol = System.getProperty(JBWS_DEPLOYER_PROTOCOL, "http-remoting");
        }
        catch (IOException e) {
            LOGGER.fatal((Object)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }
}

