/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Member;
import java.util.HashMap;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.ImmediateResourceReferenceFactory;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ContextTransactionSynchronizationRegistry;

public class WeldJpaInjectionServices
implements JpaInjectionServices {
    private DeploymentUnit deploymentUnit;

    public WeldJpaInjectionServices(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceContext context = (PersistenceContext)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(PersistenceContext.class);
        if (context == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(PersistenceContext.class, injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName(), injectionPoint.getMember());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.deploymentUnit.getServiceRegistry().getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return new EntityManagerResourceReferenceFactory(scopedPuName, persistenceUnitService.getEntityManagerFactory(), context, (TransactionSynchronizationRegistry)ContextTransactionSynchronizationRegistry.getInstance(), (TransactionManager)ContextTransactionManager.getInstance());
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceUnit context = (PersistenceUnit)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(PersistenceUnit.class);
        if (context == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(PersistenceUnit.class, injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName(), injectionPoint.getMember());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.deploymentUnit.getServiceRegistry().getRequiredService(persistenceUnitServiceName);
        PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        return new ImmediateResourceReferenceFactory((Object)persistenceUnitService.getEntityManagerFactory());
    }

    public void cleanup() {
        this.deploymentUnit = null;
    }

    private String getScopedPUName(DeploymentUnit deploymentUnit, String persistenceUnitName, Member injectionPoint) {
        PersistenceUnitMetadata scopedPu = PersistenceUnitSearch.resolvePersistenceUnitSupplier((DeploymentUnit)deploymentUnit, (String)persistenceUnitName);
        if (null == scopedPu) {
            throw WeldLogger.ROOT_LOGGER.couldNotFindPersistenceUnit(persistenceUnitName, deploymentUnit.getName(), injectionPoint);
        }
        return scopedPu.getScopedPersistenceUnitName();
    }

    private static class EntityManagerResourceReferenceFactory
    implements ResourceReferenceFactory<EntityManager> {
        private final String scopedPuName;
        private final EntityManagerFactory entityManagerFactory;
        private final PersistenceContext context;
        private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        private final TransactionManager transactionManager;

        public EntityManagerResourceReferenceFactory(String scopedPuName, EntityManagerFactory entityManagerFactory, PersistenceContext context, TransactionSynchronizationRegistry transactionSynchronizationRegistry, TransactionManager transactionManager) {
            this.scopedPuName = scopedPuName;
            this.entityManagerFactory = entityManagerFactory;
            this.context = context;
            this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
            this.transactionManager = transactionManager;
        }

        public ResourceReference<EntityManager> createResource() {
            TransactionScopedEntityManager result = new TransactionScopedEntityManager(this.scopedPuName, new HashMap(), this.entityManagerFactory, this.context.synchronization(), this.transactionSynchronizationRegistry, this.transactionManager);
            return new SimpleResourceReference((Object)result);
        }
    }
}

