/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.xts.XTSDeploymentMarker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.narayana.compensations.impl.CompensationsCDIExtension;
import org.jboss.narayana.txframework.impl.as.TXFrameworkCDIExtension;

public class CDIExtensionProcessor
implements DeploymentUnitProcessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] EXTENSIONS = new String[]{TXFrameworkCDIExtension.class.getName(), CompensationsCDIExtension.class.getName()};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (!XTSDeploymentMarker.isXTSAnnotationDeployment(unit)) {
            return;
        }
        ModuleClassLoader cl = ((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader();
        WeldPortableExtensions extensions = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)unit);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            for (String fqn : EXTENSIONS) {
                try {
                    Class<?> extension = Class.forName(fqn, true, (ClassLoader)cl);
                    extensions.tryRegisterExtension(extension, unit);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

