/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts.jandex;

import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.xts.XTSException;
import org.jboss.as.xts.jandex.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class WebServiceAnnotation {
    private static final String WEBSERVICE_ANNOTATION = WebService.class.getName();
    private final String portName;
    private final String serviceName;
    private final String name;
    private final String targetNamespace;

    private WebServiceAnnotation(String portName, String serviceName, String name, String targetNamespace) {
        this.portName = portName;
        this.serviceName = serviceName;
        this.name = name;
        this.targetNamespace = targetNamespace;
    }

    public static WebServiceAnnotation build(DeploymentUnit unit, String endpoint) throws XTSException {
        AnnotationInstance annotationInstance = JandexHelper.getAnnotation(unit, endpoint, WEBSERVICE_ANNOTATION);
        if (annotationInstance == null) {
            return null;
        }
        String portName = WebServiceAnnotation.getStringValue(annotationInstance, "portName");
        String serviceName = WebServiceAnnotation.getStringValue(annotationInstance, "serviceName");
        String name = WebServiceAnnotation.getStringValue(annotationInstance, "name");
        String targetNamespace = WebServiceAnnotation.getStringValue(annotationInstance, "targetNamespace");
        return new WebServiceAnnotation(portName, serviceName, name, targetNamespace);
    }

    private static String getStringValue(AnnotationInstance annotationInstance, String key) {
        AnnotationValue value = annotationInstance.value(key);
        if (value != null) {
            return value.asString();
        }
        if ("portName".equals(key)) {
            return WebServiceAnnotation.getTargetClassName(annotationInstance) + "Port";
        }
        if ("serviceName".equals(key)) {
            return WebServiceAnnotation.getTargetClassName(annotationInstance) + "Service";
        }
        if ("name".equals(key)) {
            return WebServiceAnnotation.getTargetClassName(annotationInstance);
        }
        if ("targetNamespace".equals(key)) {
            return WebServiceAnnotation.getTargetNamespace(annotationInstance);
        }
        return "";
    }

    private static String getTargetClassName(AnnotationInstance annotationInstance) {
        String fullName = annotationInstance.target().toString();
        int lastDotIndex = fullName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return fullName;
        }
        return fullName.substring(lastDotIndex + 1);
    }

    private static String getTargetNamespace(AnnotationInstance annotationInstance) {
        String[] parts = annotationInstance.target().toString().split("\\.");
        if (parts.length < 2) {
            return "";
        }
        Object targetNamespace = "http://";
        for (int i = parts.length - 2; i >= 0; --i) {
            targetNamespace = (String)targetNamespace + parts[i] + ".";
        }
        return ((String)targetNamespace).substring(0, ((String)targetNamespace).length() - 1) + "/";
    }

    public QName buildPortQName() {
        return new QName(this.targetNamespace, this.portName);
    }

    public String getPortName() {
        return this.portName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }
}

