/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts.jandex;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.xts.XTSException;
import org.jboss.as.xts.jandex.CompensatableAnnotation;
import org.jboss.as.xts.jandex.OldCompensatableAnnotation;
import org.jboss.as.xts.jandex.StatelessAnnotation;
import org.jboss.as.xts.jandex.TransactionalAnnotation;
import org.jboss.as.xts.jandex.WebServiceAnnotation;

public class EndpointMetaData {
    private TransactionalAnnotation transactionalAnnotation;
    private CompensatableAnnotation compensatableAnnotation;
    private OldCompensatableAnnotation oldCompensatableAnnotation;
    private WebServiceAnnotation webServiceAnnotation;
    private StatelessAnnotation statelessAnnotation;
    private boolean isTXFrameworkEnabled;

    private EndpointMetaData(StatelessAnnotation statelessAnnotation, TransactionalAnnotation transactionalAnnotation, OldCompensatableAnnotation oldCompensatableAnnotation, CompensatableAnnotation compensatableAnnotation, WebServiceAnnotation webServiceAnnotation, boolean isTXFrameworkEnabled) {
        this.statelessAnnotation = statelessAnnotation;
        this.transactionalAnnotation = transactionalAnnotation;
        this.compensatableAnnotation = compensatableAnnotation;
        this.oldCompensatableAnnotation = oldCompensatableAnnotation;
        this.webServiceAnnotation = webServiceAnnotation;
        this.isTXFrameworkEnabled = isTXFrameworkEnabled;
    }

    public static EndpointMetaData build(DeploymentUnit unit, String endpoint) throws XTSException {
        StatelessAnnotation statelessAnnotation = StatelessAnnotation.build(unit, endpoint);
        TransactionalAnnotation transactionalAnnotation = TransactionalAnnotation.build(unit, endpoint);
        CompensatableAnnotation compensatableAnnotation = CompensatableAnnotation.build(unit, endpoint);
        OldCompensatableAnnotation oldCompensatableAnnotation = OldCompensatableAnnotation.build(unit, endpoint);
        WebServiceAnnotation webServiceAnnotation = WebServiceAnnotation.build(unit, endpoint);
        boolean isTXFrameworkEnabled = transactionalAnnotation != null || oldCompensatableAnnotation != null || compensatableAnnotation != null;
        return new EndpointMetaData(statelessAnnotation, transactionalAnnotation, oldCompensatableAnnotation, compensatableAnnotation, webServiceAnnotation, isTXFrameworkEnabled);
    }

    public TransactionalAnnotation getTransactionalAnnotation() {
        return this.transactionalAnnotation;
    }

    public OldCompensatableAnnotation getOldCompensatableAnnotation() {
        return this.oldCompensatableAnnotation;
    }

    public CompensatableAnnotation getCompensatableAnnotation() {
        return this.compensatableAnnotation;
    }

    public WebServiceAnnotation getWebServiceAnnotation() {
        return this.webServiceAnnotation;
    }

    public boolean isTXFrameworkEnabled() {
        return this.isTXFrameworkEnabled;
    }

    public boolean isWebservice() {
        return this.webServiceAnnotation != null;
    }

    public boolean isEJB() {
        return this.statelessAnnotation != null;
    }
}

