/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.xts.XTSDeploymentMarker;
import org.jboss.as.xts.XTSException;
import org.jboss.as.xts.jandex.CompensatableAnnotation;
import org.jboss.as.xts.jandex.EndpointMetaData;
import org.jboss.as.xts.jandex.OldCompensatableAnnotation;
import org.jboss.as.xts.jandex.TransactionalAnnotation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class XTSHandlerDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String TX_BRIDGE_HANDLER = "org.jboss.jbossts.txbridge.inbound.OptionalJaxWSTxInboundBridgeHandler";
    private static final String TX_CONTEXT_HANDLER = "com.arjuna.mw.wst11.service.JaxWSHeaderContextProcessor";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        WebservicesMetaData webservicesMetaData = new WebservicesMetaData();
        boolean modifiedWSMeta = false;
        for (String endpoint : this.getDeploymentClasses(unit)) {
            try {
                EndpointMetaData endpointMetaData = EndpointMetaData.build(unit, endpoint);
                if (!endpointMetaData.isXTSEnabled()) continue;
                XTSDeploymentMarker.mark(unit);
                boolean result = this.updateXTSEndpoint(endpoint, endpointMetaData, webservicesMetaData, unit);
                modifiedWSMeta = modifiedWSMeta || result;
            }
            catch (XTSException e) {
                throw new DeploymentUnitProcessingException("Error processing endpoint '" + endpoint + "'", (Throwable)e);
            }
        }
        if (modifiedWSMeta) {
            unit.putAttachment(WSAttachmentKeys.WEBSERVICES_METADATA_KEY, (Object)webservicesMetaData);
        }
    }

    private boolean updateXTSEndpoint(String endpoint, EndpointMetaData endpointMetaData, WebservicesMetaData webservicesMetaData, DeploymentUnit unit) {
        if (endpointMetaData.isWebservice()) {
            ArrayList<String> handlers = new ArrayList<String>();
            if (endpointMetaData.isBridgeEnabled()) {
                handlers.add(TX_BRIDGE_HANDLER);
            }
            handlers.add(TX_CONTEXT_HANDLER);
            if (!this.isAnyOfHandlersRegistered(unit, endpoint, handlers)) {
                this.addHandlerToEndpoint(webservicesMetaData, endpointMetaData, endpoint, handlers);
                this.registerHandlersWithAS(unit, endpoint, handlers);
                return true;
            }
        }
        return false;
    }

    private void addHandlerToEndpoint(WebservicesMetaData wsWebservicesMetaData, EndpointMetaData endpointMetaData, String endpointClass, List<String> handlers) {
        WebserviceDescriptionMetaData descriptionMetaData = new WebserviceDescriptionMetaData(wsWebservicesMetaData);
        UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData = this.buildHandlerChains(handlers);
        QName portQname = endpointMetaData.getWebServiceAnnotation().buildPortQName();
        PortComponentMetaData portComponent = this.buildPortComponent(endpointMetaData.isEJB(), endpointClass, portQname, unifiedHandlerChainsMetaData, descriptionMetaData);
        descriptionMetaData.addPortComponent(portComponent);
        wsWebservicesMetaData.addWebserviceDescription(descriptionMetaData);
    }

    private PortComponentMetaData buildPortComponent(boolean isEJB, String endpointClass, QName portQname, UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData, WebserviceDescriptionMetaData descriptionMetaData) {
        PortComponentMetaData portComponent = new PortComponentMetaData(descriptionMetaData);
        portComponent.setHandlerChains(unifiedHandlerChainsMetaData);
        portComponent.setServiceEndpointInterface(endpointClass);
        portComponent.setWsdlPort(portQname);
        if (isEJB) {
            portComponent.setEjbLink(this.getClassName(endpointClass));
        } else {
            portComponent.setServletLink(endpointClass);
        }
        return portComponent;
    }

    private UnifiedHandlerChainsMetaData buildHandlerChains(List<String> handlerClasses) {
        UnifiedHandlerChainMetaData unifiedHandlerChainMetaData = new UnifiedHandlerChainMetaData();
        for (String handlerClass : handlerClasses) {
            UnifiedHandlerMetaData handlerMetaData = new UnifiedHandlerMetaData();
            handlerMetaData.setHandlerClass(handlerClass);
            unifiedHandlerChainMetaData.addHandler(handlerMetaData);
        }
        UnifiedHandlerChainsMetaData unifiedHandlerChainsMetaData = new UnifiedHandlerChainsMetaData();
        unifiedHandlerChainsMetaData.addHandlerChain(unifiedHandlerChainMetaData);
        return unifiedHandlerChainsMetaData;
    }

    private void registerHandlersWithAS(DeploymentUnit unit, String endpointClass, List<String> handlersToAdd) {
        HashSet<String> existingHandlers;
        WSEndpointHandlersMapping mapping = (WSEndpointHandlersMapping)unit.getAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY);
        if (mapping == null) {
            mapping = new WSEndpointHandlersMapping();
            unit.putAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY, (Object)mapping);
        }
        existingHandlers = (existingHandlers = mapping.getHandlers(endpointClass)) == null ? new HashSet<String>() : new HashSet(existingHandlers);
        for (String handler : handlersToAdd) {
            existingHandlers.add(handler);
        }
        mapping.registerEndpointHandlers(endpointClass, existingHandlers);
    }

    private String getClassName(String fQClass) {
        String[] split = fQClass.split("\\.");
        return split[split.length - 1];
    }

    private Set<String> getDeploymentClasses(DeploymentUnit unit) {
        HashSet<String> endpoints = new HashSet<String>();
        for (String annotation : CompensatableAnnotation.COMPENSATABLE_ANNOTATIONS) {
            this.addEndpointsToList(endpoints, ASHelper.getAnnotations((DeploymentUnit)unit, (DotName)DotName.createSimple((String)annotation)));
        }
        for (String annotation : TransactionalAnnotation.TRANSACTIONAL_ANNOTATIONS) {
            this.addEndpointsToList(endpoints, ASHelper.getAnnotations((DeploymentUnit)unit, (DotName)DotName.createSimple((String)annotation)));
        }
        for (String annotation : OldCompensatableAnnotation.COMPENSATABLE_ANNOTATIONS) {
            this.addEndpointsToList(endpoints, ASHelper.getAnnotations((DeploymentUnit)unit, (DotName)DotName.createSimple((String)annotation)));
        }
        return endpoints;
    }

    private void addEndpointsToList(Set<String> endpoints, List<AnnotationInstance> annotations) {
        for (AnnotationInstance annotationInstance : annotations) {
            String endpointClass;
            AnnotationTarget target = annotationInstance.target();
            if (target instanceof ClassInfo) {
                ClassInfo classInfo = (ClassInfo)annotationInstance.target();
                endpointClass = classInfo.name().toString();
                endpoints.add(endpointClass);
                continue;
            }
            if (!(target instanceof MethodInfo)) continue;
            MethodInfo methodInfo = (MethodInfo)target;
            endpointClass = methodInfo.declaringClass().name().toString();
            endpoints.add(endpointClass);
        }
    }

    private boolean isAnyOfHandlersRegistered(DeploymentUnit unit, String endpointClass, List<String> handlers) {
        WSEndpointHandlersMapping mapping = (WSEndpointHandlersMapping)unit.getAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY);
        if (mapping == null) {
            return false;
        }
        Set existingHandlers = mapping.getHandlers(endpointClass);
        if (existingHandlers == null) {
            return false;
        }
        for (String handler : handlers) {
            if (!existingHandlers.contains(handler)) continue;
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit unit) {
    }
}

