/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class ConfigurableProperties {
    private final ConcurrentHashMap<String, String> map = new ConcurrentHashMap(8);

    public synchronized void load(Properties props) {
        Args.notNull(props, "props");
        for (String name : props.stringPropertyNames()) {
            this.setProperty(name, props.getProperty(name));
        }
    }

    public synchronized void load(InputStream inStream) throws IOException {
        Args.notNull(inStream, "inStream");
        this.load(new InputStreamReader(inStream));
    }

    public synchronized void load(Reader reader) throws IOException {
        Args.notNull(reader, "reader");
        Properties props = new Properties();
        props.load(reader);
        for (String name : props.stringPropertyNames()) {
            String value = props.getProperty(name);
            this.setProperty(name, value);
        }
    }

    public String getProperty(String key) {
        return this.map.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    public Set<String> propertyNames() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public synchronized String setProperty(String key, String value) {
        return this.map.put(key, StringUtil.resolveVariables(value));
    }

    public synchronized String remove(String key) {
        return this.map.remove(key);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized String toString() {
        return this.map.toString();
    }

    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (String name : this.propertyNames()) {
            props.setProperty(name, this.map.get(name));
        }
        return props;
    }
}

