/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.Base64;
import org.xipki.util.Curl;
import org.xipki.util.IoUtil;
import org.xipki.util.JSON;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidableConf;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.SslConf;
import org.xipki.util.http.SslContextConf;

public class DefaultCurl
implements Curl {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCurl.class);
    private boolean useSslConf = true;
    private String confFile;
    private SslContextConf sslContextConf;
    private Map<UrlPattern, SslContextConf> sslContextConfs = new HashMap<UrlPattern, SslContextConf>();
    private UrlPattern[] urlPatterns;
    private boolean initialized;

    public void setUseSslConf(boolean useSslConf) {
        this.useSslConf = useSslConf;
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public void setSslContextConf(SslContextConf sslContextConf) {
        this.sslContextConf = sslContextConf;
    }

    private synchronized void initIfNotDone() throws ObjectCreationException {
        if (this.initialized) {
            return;
        }
        try {
            if (this.useSslConf) {
                if (this.sslContextConf != null) {
                    UrlPattern urlPattern = new UrlPattern("*:*/*");
                    try {
                        this.sslContextConf.init();
                        this.sslContextConfs.put(urlPattern, this.sslContextConf);
                        LOG.info("initialized SslContextConf for UrlPattern {}", (Object)urlPattern);
                    }
                    catch (ObjectCreationException ex) {
                        LogUtil.error(LOG, ex, "error initializing sslContextConf");
                    }
                } else if (this.confFile != null) {
                    CurlConf conf = JSON.parseConf(Path.of(this.confFile, new String[0]), CurlConf.class);
                    conf.validate();
                    for (HostConf m : conf.hostConfs) {
                        SslContextConf sslContextConf = SslContextConf.ofSslConf(m.sslContext);
                        try {
                            sslContextConf.init();
                            for (String p : m.urlPattern) {
                                this.sslContextConfs.put(new UrlPattern(p), sslContextConf);
                            }
                            LOG.info("initialized SslContextConf for UrlPattern {}", m.urlPattern);
                        }
                        catch (ObjectCreationException ex) {
                            LogUtil.error(LOG, ex, "error initializing SslContextConf for URL pattern " + m.urlPattern);
                        }
                    }
                } else {
                    LOG.info("neither confFile nor sslContextConf is configured, skipping.");
                }
                ArrayList<UrlPattern> patterns = new ArrayList<UrlPattern>(this.sslContextConfs.keySet());
                this.urlPatterns = patterns.toArray(new UrlPattern[0]);
            }
        }
        catch (IOException | InvalidConfException ex) {
            LogUtil.error(LOG, ex, "error initializing DefaultCurl");
            throw new ObjectCreationException("error initializing DefaultCurl: " + ex.getMessage());
        }
        finally {
            this.initialized = true;
        }
    }

    private static void println(String text) {
        System.out.println(text);
    }

    @Override
    public Curl.CurlResult curlGet(String url, boolean verbose, Map<String, String> headers, String userPassword) throws Exception {
        this.checkUserPassword(userPassword);
        return this.curlGet(url, null, verbose, headers, userPassword);
    }

    @Override
    public Curl.CurlResult curlGet(String url, OutputStream respContentStream, boolean verbose, Map<String, String> headers, String userPassword) throws Exception {
        return this.curl(false, url, respContentStream, verbose, headers, userPassword, null);
    }

    @Override
    public Curl.CurlResult curlPost(String url, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        return this.curlPost(url, null, verbose, headers, userPassword, content);
    }

    @Override
    public Curl.CurlResult curlPost(String url, OutputStream respContentStream, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        return this.curl(true, url, respContentStream, verbose, headers, userPassword, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Curl.CurlResult curl(boolean post, String url, OutputStream respContentStream, boolean verbose, Map<String, String> headers, String userPassword, byte[] content) throws Exception {
        if (!post && content != null) {
            throw new IllegalArgumentException("method GET cannot be used to transfer non-empty content");
        }
        this.checkUserPassword(userPassword);
        this.initIfNotDone();
        URL newUrl = new URL(url);
        HttpURLConnection httpConn = IoUtil.openHttpConn(newUrl);
        if (this.useSslConf && this.urlPatterns != null && this.urlPatterns.length > 0 && httpConn instanceof HttpsURLConnection) {
            Object sslContextConf = null;
            for (UrlPattern m : this.urlPatterns) {
                if (!m.match(newUrl)) continue;
                sslContextConf = this.sslContextConfs.get(m);
                break;
            }
            if (sslContextConf != null) {
                HostnameVerifier verifier;
                HttpsURLConnection httpsConn = (HttpsURLConnection)httpConn;
                SSLSocketFactory sSLSocketFactory = ((SslContextConf)sslContextConf).getSslSocketFactory();
                if (sSLSocketFactory != null) {
                    httpsConn.setSSLSocketFactory(sSLSocketFactory);
                }
                if ((verifier = ((SslContextConf)sslContextConf).getHostnameVerifier()) != null) {
                    httpsConn.setHostnameVerifier(verifier);
                }
            }
        }
        try {
            void var12_20;
            Map<String, List<String>> properties;
            httpConn.setRequestMethod(post ? "POST" : "GET");
            httpConn.setUseCaches(false);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String string = entry.getValue();
                    httpConn.setRequestProperty(entry.getKey(), string);
                }
            }
            if (userPassword != null) {
                httpConn.setRequestProperty("Authorization", "Basic " + Base64.encodeToString(StringUtil.toUtf8Bytes(userPassword)));
            }
            if (content == null) {
                properties = httpConn.getRequestProperties();
            } else {
                httpConn.setDoOutput(true);
                httpConn.setRequestProperty("Content-Length", Integer.toString(content.length));
                properties = httpConn.getRequestProperties();
                OutputStream outputstream = httpConn.getOutputStream();
                outputstream.write(content);
                outputstream.flush();
            }
            if (verbose) {
                DefaultCurl.println("=====request=====");
                DefaultCurl.println("  HTTP method: " + httpConn.getRequestMethod());
                for (Map.Entry entry : properties.entrySet()) {
                    for (String value : (List)entry.getValue()) {
                        DefaultCurl.println("  " + (String)entry.getKey() + ": " + value);
                    }
                }
            }
            int respCode = httpConn.getResponseCode();
            if (verbose) {
                DefaultCurl.println("=====response=====");
                DefaultCurl.println("  response code: " + respCode + " " + httpConn.getResponseMessage());
                properties = httpConn.getHeaderFields();
                for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    List<String> values = entry.getValue();
                    for (String value : values) {
                        DefaultCurl.println("  " + key + ": " + value);
                    }
                }
                DefaultCurl.println("=====response content=====");
            } else if (respCode != 200) {
                DefaultCurl.println("ERROR: bad response: " + httpConn.getResponseCode() + "    " + httpConn.getResponseMessage());
            }
            Object var12_18 = null;
            InputStream errorStream = null;
            try {
                InputStream inputStream = httpConn.getInputStream();
            }
            catch (IOException ex) {
                errorStream = httpConn.getErrorStream();
            }
            Curl.CurlResult result = new Curl.CurlResult(respCode);
            result.setContentType(httpConn.getHeaderField("Content-Type"));
            if (var12_20 != null) {
                if (respContentStream == null) {
                    result.setContent(IoUtil.readAllBytesAndClose((InputStream)var12_20));
                } else {
                    int read;
                    byte[] buffer = new byte[8192];
                    int contentLength = 0;
                    while ((read = var12_20.read(buffer)) != -1) {
                        contentLength += read;
                        respContentStream.write(buffer, 0, read);
                    }
                    result.setContentLength(contentLength);
                }
            } else if (errorStream != null) {
                result.setErrorContent(IoUtil.readAllBytesAndClose(errorStream));
            }
            Curl.CurlResult curlResult = result;
            return curlResult;
        }
        finally {
            httpConn.disconnect();
        }
    }

    private void checkUserPassword(String userPassword) {
        if (userPassword == null) {
            return;
        }
        int idx = userPassword.indexOf(58);
        if (idx == -1 || idx == userPassword.length() - 1) {
            throw new IllegalArgumentException("invalid userPassword");
        }
    }

    private static final class UrlPattern {
        private final String host;
        private final Integer port;
        private final String path;
        private final String toString;

        public UrlPattern(String pattern) {
            String port0;
            String host0;
            if (pattern.startsWith("https://")) {
                pattern = pattern.substring("https://".length());
            }
            int index = pattern.indexOf(47);
            this.path = pattern.substring(index);
            String token0 = pattern.substring(0, index);
            if ((index = token0.indexOf(58)) == -1) {
                host0 = token0;
                port0 = "";
            } else {
                host0 = token0.substring(0, index);
                port0 = token0.substring(index + 1);
            }
            String string = this.host = StringUtil.isBlank(host0) ? "*" : host0;
            if (StringUtil.isBlank(port0)) {
                this.port = 443;
                port0 = "443";
            } else {
                this.port = "*".equals(port0) ? null : Integer.valueOf(Integer.parseInt(port0));
            }
            this.toString = this.host + ":" + port0 + this.path;
        }

        public boolean match(URL url) {
            if (!"*".equals(this.host) && !url.getHost().contains(this.host)) {
                return false;
            }
            if (this.port != null) {
                int tPort = url.getPort();
                if (tPort == -1) {
                    tPort = 443;
                }
                if (this.port != tPort) {
                    return false;
                }
            }
            if (!"/*".equals(this.path)) {
                String tPath = url.getPath();
                return tPath != null && tPath.startsWith(this.path);
            }
            return true;
        }

        public int hashCode() {
            return this.toString.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof UrlPattern) {
                return this.toString.equals(((UrlPattern)other).toString);
            }
            return false;
        }

        public String toString() {
            return this.toString;
        }
    }

    private static final class CurlConf
    extends ValidableConf {
        private List<HostConf> hostConfs;

        private CurlConf() {
        }

        public void setHostConfs(List<HostConf> hostConfs) {
            this.hostConfs = hostConfs;
        }

        @Override
        public void validate() throws InvalidConfException {
            if (this.hostConfs == null) {
                return;
            }
            HashSet<String> urlPatterns = new HashSet<String>();
            for (HostConf m : this.hostConfs) {
                for (String p : m.urlPattern) {
                    if (urlPatterns.contains(p)) {
                        throw new InvalidConfException("duplicated urlPattern " + p);
                    }
                    urlPatterns.add(p);
                }
                m.validate();
            }
        }
    }

    private static final class HostConf
    extends ValidableConf {
        private List<String> urlPattern;
        private SslConf sslContext;

        private HostConf() {
        }

        public void setUrlPattern(List<String> urlPattern) {
            this.urlPattern = urlPattern;
        }

        public void setSslContext(SslConf sslContext) {
            this.sslContext = sslContext;
        }

        @Override
        public void validate() throws InvalidConfException {
            HostConf.notNull(this.urlPattern, "urlPattern");
            HostConf.notNull(this.sslContext, "sslContext");
        }
    }
}

