/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.util;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.util.StringUtil;

public class ProcessLog {
    private static final long MS_900 = 900L;
    private static final int DURATION_LEN = 10;
    private static final int PERCENT_LEN = 6;
    private static final int SPEED_LEN = 10;
    private static final int TIME_LEN = 10;
    private static final int TOTAL_LEN = 15;
    private long total;
    private boolean hasTotal;
    private Instant startTime;
    private Instant endTime;
    private AtomicLong numProcessed;
    private Instant lastPrintTime;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private Duration totalElapsedTime;
    private int totalAverageSpeed;
    private final ConcurrentLinkedDeque<MeasurePoint> measureDeque = new ConcurrentLinkedDeque();

    public ProcessLog(long total) {
        this.total = total;
        this.reset();
    }

    public void printHeader() {
        StringBuilder sb = new StringBuilder();
        int lineLength = this.getLineLength();
        sb.append("-".repeat(Math.max(0, lineLength)));
        sb.append('\n');
        sb.append(ProcessLog.formatText("", 15));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("", 6));
        }
        sb.append(ProcessLog.formatText("average", 10)).append(ProcessLog.formatText("current", 10)).append(ProcessLog.formatText("time", 10));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("time", 10)).append(ProcessLog.formatText("finish", 10));
        }
        sb.append('\n');
        sb.append(StringUtil.formatText("total", 15));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("%", 6));
        }
        sb.append(ProcessLog.formatText("speed", 10)).append(ProcessLog.formatText("speed", 10)).append(ProcessLog.formatText("spent", 10));
        if (this.hasTotal) {
            sb.append(ProcessLog.formatText("left", 10)).append(ProcessLog.formatText("at", 10));
        }
        sb.append('\n');
        System.out.println(sb);
        System.out.flush();
    }

    public void finish() {
        this.finished.set(true);
        this.endTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.totalElapsedTime = Duration.between(this.startTime, this.endTime);
        this.totalAverageSpeed = 0;
        if (this.totalElapsedTime.toMillis() > 0L) {
            this.totalAverageSpeed = (int)ProcessLog.averagePerSecond(this.numProcessed.get(), this.totalElapsedTime.toMillis());
        }
    }

    public void printTrailer() {
        this.finish();
        this.printStatus(true);
        StringBuilder sb = new StringBuilder().append('\n');
        int lineLength = this.getLineLength();
        sb.append("-".repeat(Math.max(0, lineLength)));
        System.out.println(sb);
        System.out.flush();
    }

    public long numProcessed() {
        return this.numProcessed.get();
    }

    public long total() {
        return this.total;
    }

    public void total(long total) {
        this.total = total;
    }

    public final void reset() {
        this.startTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.numProcessed = new AtomicLong(0L);
        this.lastPrintTime = Instant.ofEpochMilli(0L);
        this.measureDeque.clear();
        this.measureDeque.add(new MeasurePoint(this.startTime, 0L));
        this.hasTotal = this.total > 0L;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public long addNumProcessed(long numProcessed) {
        return this.numProcessed.addAndGet(numProcessed);
    }

    public void printStatus() {
        this.printStatus(false);
    }

    private void printStatus(boolean forcePrint) {
        Instant now = Instant.now();
        long tmpNumProcessed = this.numProcessed.get();
        if (!forcePrint && Duration.between(this.lastPrintTime, now).toMillis() < 900L) {
            return;
        }
        this.measureDeque.addLast(new MeasurePoint(now, this.numProcessed.get()));
        this.lastPrintTime = now;
        int numMeasurePoints = this.measureDeque.size();
        MeasurePoint referenceMeasurePoint = numMeasurePoints > 10 ? this.measureDeque.removeFirst() : this.measureDeque.getFirst();
        StringBuilder sb = new StringBuilder("\r");
        sb.append(StringUtil.formatAccount(tmpNumProcessed, 15));
        if (this.hasTotal) {
            int percent = (int)(tmpNumProcessed * 100L / this.total);
            sb.append(ProcessLog.formatText(percent + "%", 6));
        }
        long averageSpeed = 0L;
        long elapsedTimeMilli = Duration.between(this.startTime, now).toMillis();
        if (elapsedTimeMilli > 0L) {
            averageSpeed = ProcessLog.averagePerSecond(tmpNumProcessed, elapsedTimeMilli);
        }
        sb.append(StringUtil.formatAccount(averageSpeed, 10));
        long currentSpeed = 0L;
        long t2Milli = Duration.between(referenceMeasurePoint.measureTime, now).toMillis();
        if (t2Milli > 0L) {
            currentSpeed = ProcessLog.averagePerSecond(tmpNumProcessed - referenceMeasurePoint.measureAccount, t2Milli);
        }
        sb.append(StringUtil.formatAccount(currentSpeed, 10));
        sb.append(StringUtil.formatTime(elapsedTimeMilli / 1000L, 10));
        if (this.hasTotal) {
            long remainTimeSeconds = -1L;
            if (currentSpeed > 0L) {
                remainTimeSeconds = (this.total - tmpNumProcessed) / currentSpeed;
            }
            Instant finishAt = null;
            if (remainTimeSeconds != -1L) {
                finishAt = now.plus(remainTimeSeconds, ChronoUnit.SECONDS);
            }
            if (remainTimeSeconds < 1L) {
                sb.append(ProcessLog.formatText("--", 10)).append(ProcessLog.formatText("--", 10));
            } else {
                sb.append(StringUtil.formatTime(remainTimeSeconds, 10)).append(ProcessLog.buildDateTime(finishAt));
            }
        }
        System.out.print(sb);
        System.out.flush();
    }

    public Duration totalElapsedTime() {
        if (this.finished.get()) {
            return this.totalElapsedTime;
        }
        return Duration.between(this.startTime, Instant.now());
    }

    public int totalAverageSpeed() {
        if (this.finished.get()) {
            return this.totalAverageSpeed;
        }
        Duration elapsedTime = Duration.between(this.startTime, Instant.now());
        int averageSpeed = 0;
        if (!elapsedTime.isZero()) {
            averageSpeed = (int)ProcessLog.averagePerSecond(this.numProcessed.get(), elapsedTime.toMillis());
        }
        return averageSpeed;
    }

    private static String formatText(String text, int minLen) {
        return StringUtil.formatText(text, minLen);
    }

    private static String buildDateTime(Instant time) {
        ZonedDateTime cal = time.atZone(ZoneId.systemDefault());
        StringBuilder sb = new StringBuilder();
        int hour = cal.getHour();
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        int minute = cal.getMinute();
        sb.append(":");
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        int second = cal.getSecond();
        sb.append(":");
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime midNight = ZonedDateTime.of(now.getYear(), now.getMonthValue(), now.getDayOfMonth(), 0, 0, 0, 0, now.getZone());
        long days = Duration.between(midNight.toInstant(), time).toDays();
        if (days > 0L) {
            sb.append('+').append(days > 9L ? "x" : Long.toString(days));
        }
        int size = sb.length();
        for (int i = 0; i < 10 - size; ++i) {
            sb.insert(0, ' ');
        }
        return sb.toString();
    }

    private int getLineLength() {
        int len = 15;
        if (this.hasTotal) {
            len += 6;
        }
        len += 30;
        if (this.hasTotal) {
            len += 20;
        }
        return len;
    }

    private static long averagePerSecond(long value, long millis) {
        return value * 1000L / millis;
    }

    private static class MeasurePoint {
        private final Instant measureTime;
        private final long measureAccount;

        public MeasurePoint(Instant measureTime, long measureAccount) {
            this.measureTime = measureTime;
            this.measureAccount = measureAccount;
        }
    }
}

