/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xrest;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.xyou.xcommon.application.XApp;
import org.xyou.xcommon.balance.XBalance;
import org.xyou.xcommon.base.XObject;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.exception.XEx;
import org.xyou.xcommon.file.XFile;
import org.xyou.xcommon.function.XConsumer;
import org.xyou.xcommon.function.XFunction;
import org.xyou.xcommon.sequence.XSeq;
import org.xyou.xcommon.string.XStr;
import org.xyou.xcommon.url.XUrl;

public final class XRest
extends XObject
implements AutoCloseable {
    static final Set<String> SET_PREFIX_MSG_HOST_DOWN = XSeq.newHashSet((Object[])new String[]{"unexpected end of stream on", "Failed to connect to"});
    private static final String nameInst = "xrest-inst";
    private static final AtomicReference<Object> inst = new AtomicReference();
    String name;
    String host;
    Long msTimeout;
    Integer sizePoolMax;
    transient Boolean isNoHost;
    transient OkHttpClient client;
    transient XBalance<String> balance;

    public XRest() {
        this.init(new XConfig().setName(nameInst).put("host", (Object)""));
    }

    public XRest(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.init(new XConfig(name));
    }

    public XRest(@NonNull XConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.init(config);
    }

    void init(@NonNull XConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.name = config.getName();
        this.host = config.getStr("host");
        this.msTimeout = config.getLong("msTimeout", Long.valueOf(10000L));
        this.sizePoolMax = config.getInt("sizePoolMax", Integer.valueOf(5));
        this.isNoHost = this.host.equals("");
        this.client = new OkHttpClient.Builder().connectTimeout(this.msTimeout.longValue(), TimeUnit.MILLISECONDS).writeTimeout(this.msTimeout.longValue(), TimeUnit.MILLISECONDS).readTimeout(this.msTimeout.longValue(), TimeUnit.MILLISECONDS).callTimeout(this.msTimeout.longValue(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(false).connectionPool(new ConnectionPool(this.sizePoolMax.intValue(), 300000L, TimeUnit.MILLISECONDS)).build();
        this.initBalance();
    }

    void initBalance() {
        List lsHost = XCls.toLsStr((Object)this.host);
        if (this.isNoHost.booleanValue()) {
            lsHost = XSeq.newArrayList((Object[])new String[]{""});
        }
        this.balance = new XBalance((Iterable)lsHost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Result request(@NonNull RequestParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        try {
            XConsumer<Request.Builder> updateBuilder;
            String strQuery;
            Request.Builder builderRequest = new Request.Builder();
            builderRequest.addHeader("X-Source", XApp.getName());
            Param paramClient = param.getParamClient();
            XObj header = paramClient.getHeader();
            if (!XObj.isEmpty((XObj)header)) {
                header.getMap().entrySet().forEach(entry -> {
                    String key = XCls.toStr(entry.getKey());
                    String value = XCls.toStr(entry.getValue());
                    builderRequest.addHeader(key, value);
                });
            }
            XObj query = paramClient.getQuery();
            StringJoiner builderQuery = new StringJoiner("&");
            if (!XObj.isEmpty((XObj)query)) {
                query.getMap().entrySet().forEach(entry -> {
                    String key = XCls.toStr(entry.getKey());
                    String value = XCls.toStr(entry.getValue());
                    builderQuery.add(key + "=" + value);
                });
            }
            if (!XStr.isEmpty((String)(strQuery = builderQuery.toString()))) {
                strQuery = "?" + strQuery;
            }
            if ((updateBuilder = param.getUpdateBuilder()) != null) {
                updateBuilder.accept((Object)builderRequest);
            }
            String host = null;
            block22: while (true) {
                try {
                    host = (String)this.balance.get();
                    String path = paramClient.getPath();
                    if (this.isNoHost.booleanValue()) {
                        new XUrl(path);
                    } else {
                        if (path == null) {
                            path = "/";
                        }
                        if (!path.startsWith("/")) {
                            path = "/" + path;
                        }
                    }
                    String url = String.format("%s%s%s", host, path, strQuery);
                    builderRequest.url(url);
                    Request request = builderRequest.build();
                    try (Response response = this.client.newCall(request).execute();){
                        Result.ResultBuilder builderResult = Result.builder();
                        if (this.isNoHost.booleanValue()) {
                            host = XUrl.getOrigin((String)path);
                        }
                        builderResult.host(host);
                        builderResult.code(response.code());
                        builderResult.message(response.message());
                        XObj headerResult = new XObj();
                        builderResult.header(headerResult);
                        Headers headerResponse = response.headers();
                        headerResponse.names().forEach(name -> headerResult.put(name, (Object)headerResponse.get(name)));
                        ResponseBody body = response.body();
                        String pathDownload = paramClient.getPathDownload();
                        if (pathDownload != null) {
                            XFile.mkdir((String)XFile.dirname((String)pathDownload));
                            File file = new File(pathDownload);
                            BufferedSource source = body.source();
                            try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));){
                                sink.writeAll((Source)source);
                            }
                        } else {
                            String bodyStr = body.string();
                            builderResult.body(bodyStr);
                        }
                        Result result = builderResult.build();
                        return result;
                    }
                }
                catch (IOException e) {
                    String msg = e.getMessage();
                    boolean isHostDown = false;
                    for (String prefix : SET_PREFIX_MSG_HOST_DOWN) {
                        if (!msg.startsWith(prefix)) continue;
                        isHostDown = true;
                        if (this.balance.sleep((Object)host)) continue block22;
                        throw e;
                    }
                    if (isHostDown) continue;
                    throw e;
                }
                break;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static RequestBody buildBodyReq(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return RequestBody.create((String)param.getBody().toString(), (MediaType)MediaType.parse((String)"application/json"));
    }

    public Result download(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.request(RequestParam.builder().paramClient(param).build());
    }

    public Result get() {
        return this.get(Param.builder().build());
    }

    public Result get(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.get(Param.builder().path(path).build());
    }

    public Result get(@NonNull XObj query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.get(Param.builder().query(query).build());
    }

    public Result get(@NonNull String path, @NonNull XObj query) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.get(Param.builder().path(path).query(query).build());
    }

    public Result get(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.request(RequestParam.builder().paramClient(param).build());
    }

    static void sendJson(@NonNull XFunction<RequestBody, Request.Builder> func, @NonNull Request.Builder builder, @NonNull Param param) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        func.apply((Object)XRest.buildBodyReq(param));
    }

    public Result post(@NonNull XObj body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(Param.builder().body(body).build());
    }

    public Result post(@NonNull String path, @NonNull XObj body) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(Param.builder().path(path).body(body).build());
    }

    public Result post(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        String pathUpload = param.getPathUpload();
        if (pathUpload == null) {
            XEx.checkFieldNotNull((Object)((Object)param), (String[])new String[]{"body"});
            return this.request(RequestParam.builder().paramClient(param).updateBuilder((XConsumer<Request.Builder>)(XConsumer & Serializable)b -> XRest.sendJson((XFunction<RequestBody, Request.Builder>)((XFunction & Serializable)arg_0 -> ((Request.Builder)b).post(arg_0)), b, param)).build());
        }
        File file = new File(pathUpload);
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"))).build();
        return this.request(RequestParam.builder().paramClient(param).updateBuilder((XConsumer<Request.Builder>)((XConsumer & Serializable)arg_0 -> XRest.lambda$post$bdd1a3d1$1((RequestBody)body, arg_0))).build());
    }

    public Result put(@NonNull XObj body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.put(Param.builder().body(body).build());
    }

    public Result put(@NonNull String path, @NonNull XObj body) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.put(Param.builder().path(path).body(body).build());
    }

    public Result put(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        XEx.checkFieldNotNull((Object)((Object)param), (String[])new String[]{"body"});
        return this.request(RequestParam.builder().paramClient(param).updateBuilder((XConsumer<Request.Builder>)(XConsumer & Serializable)b -> XRest.sendJson((XFunction<RequestBody, Request.Builder>)((XFunction & Serializable)arg_0 -> ((Request.Builder)b).put(arg_0)), b, param)).build());
    }

    public Result delete() {
        return this.delete(Param.builder().build());
    }

    public Result delete(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.delete(Param.builder().path(path).build());
    }

    public Result delete(@NonNull XObj query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.delete(Param.builder().query(query).build());
    }

    public Result delete(@NonNull String path, @NonNull XObj query) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.delete(Param.builder().path(path).query(query).build());
    }

    public static Result delete1(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return XRest.getInst().delete(param);
    }

    public Result delete(@NonNull Param param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.request(RequestParam.builder().paramClient(param).updateBuilder((XConsumer<Request.Builder>)(XConsumer & Serializable)b -> b.delete()).build());
    }

    void reload() {
        this.client.connectionPool().evictAll();
        this.initBalance();
    }

    @Override
    public void close() {
        this.balance.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XRest getInst() {
        Object value = inst.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = inst;
            synchronized (atomicReference) {
                value = inst.get();
                if (value == null) {
                    XRest actualValue = new XRest();
                    value = actualValue == null ? inst : actualValue;
                    inst.set(value);
                }
            }
        }
        return (XRest)(value == inst ? null : value);
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public Long getMsTimeout() {
        return this.msTimeout;
    }

    public Integer getSizePoolMax() {
        return this.sizePoolMax;
    }

    Boolean getIsNoHost() {
        return this.isNoHost;
    }

    private static /* synthetic */ void lambda$post$bdd1a3d1$1(RequestBody body, Request.Builder b) {
        b.post(body);
    }

    static class RequestParam {
        Param paramClient;
        transient XConsumer<Request.Builder> updateBuilder;

        RequestParam(Param paramClient, XConsumer<Request.Builder> updateBuilder) {
            this.paramClient = paramClient;
            this.updateBuilder = updateBuilder;
        }

        public static RequestParamBuilder builder() {
            return new RequestParamBuilder();
        }

        public Param getParamClient() {
            return this.paramClient;
        }

        public XConsumer<Request.Builder> getUpdateBuilder() {
            return this.updateBuilder;
        }

        public static class RequestParamBuilder {
            private Param paramClient;
            private XConsumer<Request.Builder> updateBuilder;

            RequestParamBuilder() {
            }

            public RequestParamBuilder paramClient(Param paramClient) {
                this.paramClient = paramClient;
                return this;
            }

            public RequestParamBuilder updateBuilder(XConsumer<Request.Builder> updateBuilder) {
                this.updateBuilder = updateBuilder;
                return this;
            }

            public RequestParam build() {
                return new RequestParam(this.paramClient, this.updateBuilder);
            }

            public String toString() {
                return "XRest.RequestParam.RequestParamBuilder(paramClient=" + (Object)((Object)this.paramClient) + ", updateBuilder=" + this.updateBuilder + ")";
            }
        }
    }

    public static class Result
    extends XObject {
        String host;
        Integer code;
        String message;
        XObj header;
        String body;

        Result(String host, Integer code, String message, XObj header, String body) {
            this.host = host;
            this.code = code;
            this.message = message;
            this.header = header;
            this.body = body;
        }

        static ResultBuilder builder() {
            return new ResultBuilder();
        }

        public String getHost() {
            return this.host;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public XObj getHeader() {
            return this.header;
        }

        public String getBody() {
            return this.body;
        }

        static class ResultBuilder {
            private String host;
            private Integer code;
            private String message;
            private XObj header;
            private String body;

            ResultBuilder() {
            }

            ResultBuilder host(String host) {
                this.host = host;
                return this;
            }

            ResultBuilder code(Integer code) {
                this.code = code;
                return this;
            }

            ResultBuilder message(String message) {
                this.message = message;
                return this;
            }

            ResultBuilder header(XObj header) {
                this.header = header;
                return this;
            }

            ResultBuilder body(String body) {
                this.body = body;
                return this;
            }

            Result build() {
                return new Result(this.host, this.code, this.message, this.header, this.body);
            }

            public String toString() {
                return "XRest.Result.ResultBuilder(host=" + this.host + ", code=" + this.code + ", message=" + this.message + ", header=" + this.header + ", body=" + this.body + ")";
            }
        }
    }

    public static class Param
    extends XObject {
        String path;
        XObj query;
        XObj header;
        Object body;
        String pathUpload;
        String pathDownload;

        Param(String path, XObj query, XObj header, Object body, String pathUpload, String pathDownload) {
            this.path = path;
            this.query = query;
            this.header = header;
            this.body = body;
            this.pathUpload = pathUpload;
            this.pathDownload = pathDownload;
        }

        public static ParamBuilder builder() {
            return new ParamBuilder();
        }

        public String getPath() {
            return this.path;
        }

        public XObj getQuery() {
            return this.query;
        }

        public XObj getHeader() {
            return this.header;
        }

        public Object getBody() {
            return this.body;
        }

        public String getPathUpload() {
            return this.pathUpload;
        }

        public String getPathDownload() {
            return this.pathDownload;
        }

        public static class ParamBuilder {
            private String path;
            private XObj query;
            private XObj header;
            private Object body;
            private String pathUpload;
            private String pathDownload;

            ParamBuilder() {
            }

            public ParamBuilder path(String path) {
                this.path = path;
                return this;
            }

            public ParamBuilder query(XObj query) {
                this.query = query;
                return this;
            }

            public ParamBuilder header(XObj header) {
                this.header = header;
                return this;
            }

            public ParamBuilder body(Object body) {
                this.body = body;
                return this;
            }

            public ParamBuilder pathUpload(String pathUpload) {
                this.pathUpload = pathUpload;
                return this;
            }

            public ParamBuilder pathDownload(String pathDownload) {
                this.pathDownload = pathDownload;
                return this;
            }

            public Param build() {
                return new Param(this.path, this.query, this.header, this.body, this.pathUpload, this.pathDownload);
            }

            public String toString() {
                return "XRest.Param.ParamBuilder(path=" + this.path + ", query=" + this.query + ", header=" + this.header + ", body=" + this.body + ", pathUpload=" + this.pathUpload + ", pathDownload=" + this.pathDownload + ")";
            }
        }
    }
}

