/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xrest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import lombok.NonNull;
import org.xyou.xcommon.base.XObject;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.config.XConfig;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.exception.XEx;
import org.xyou.xcommon.file.XFile;
import org.xyou.xcommon.format.XJson;
import org.xyou.xcommon.function.XConsumer;
import org.xyou.xcommon.function.XConsumer2;
import org.xyou.xcommon.function.XFunction;
import org.xyou.xcommon.function.XFunction2;
import org.xyou.xcommon.log.XLog;
import org.xyou.xcommon.profile.XProfile;
import org.xyou.xcommon.profile.XProfileObj;
import org.xyou.xcommon.profile.XProfileTimer;
import org.xyou.xcommon.sequence.XSeq;
import org.xyou.xcommon.string.XStr;
import org.xyou.xrest.XRestStatus;
import spark.HaltException;
import spark.Route;
import spark.Service;

public final class XRestServer
extends XObject {
    String name;
    String host;
    Integer numThread;
    String pathStatic;
    Boolean isProfiler;
    transient Service service;
    transient XProfileObj objProfiler;

    public XRestServer(@NonNull XConfig config) {
        this(config, null);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public XRestServer(@NonNull XConfig config, @NonNull XConsumer<XRestServer> buildHandler) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (buildHandler == null) {
            throw new NullPointerException("buildHandler is marked non-null but is null");
        }
        this.init(config, buildHandler);
    }

    public XRestServer(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.init(name, null);
    }

    public XRestServer(@NonNull String name, @NonNull XConsumer<XRestServer> buildHandler) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (buildHandler == null) {
            throw new NullPointerException("buildHandler is marked non-null but is null");
        }
        this.init(name, buildHandler);
    }

    void init(@NonNull String name, XConsumer<XRestServer> buildHandler) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.init(new XConfig(name), buildHandler);
    }

    void init(@NonNull XConfig config, XConsumer<XRestServer> buildHandler) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.name = config.getName();
        this.host = config.getStr("host");
        this.numThread = config.getInt("numThread");
        this.pathStatic = config.getStr("pathStatic", null);
        this.isProfiler = config.getBool("isProfiler", Boolean.valueOf(false));
        this.service = Service.ignite();
        String[] arrPartHost = this.host.split(":");
        String ip = arrPartHost[0];
        Integer port = XCls.toInt((Object)arrPartHost[1]);
        XLog.info((Object)String.format("Service starting at %s", this.host));
        this.service.ipAddress(ip);
        this.service.port(port.intValue());
        this.service.threadPool(this.numThread.intValue());
        if (this.pathStatic != null) {
            Service.StaticFiles dirStatic = this.service.staticFiles;
            dirStatic.location(this.pathStatic);
            dirStatic.expireTime(Integer.MAX_VALUE);
        }
        this.all((XConsumer<String>)(XConsumer & Serializable)p -> {
            this.service.before(p, (req, resp) -> {
                resp.header("Access-Control-Allow-Origin", "*");
                resp.header("Access-Control-Allow-Headers", "Content-Type, Authorization, Range");
                resp.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
                resp.header("Connection", "keep-alive");
            });
            this.service.options(p, (req, resp) -> null);
        });
        if (buildHandler != null) {
            buildHandler.accept((Object)this);
        }
        this.service.awaitInitialization();
        XLog.info((Object)String.format("Service started successfully at %s", this.host));
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfile.createObj((String)this.name);
        }
    }

    static String processPath(String path) {
        if (XStr.isEmpty((String)path)) {
            return "";
        }
        return XFile.normpath((String)path);
    }

    Response buildResponse(@NonNull spark.Request req, @NonNull spark.Response resp) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (resp == null) {
            throw new NullPointerException("resp is marked non-null but is null");
        }
        return Response.builder().service(this.service).req(req).resp(resp).header(new XObj()).build();
    }

    Request buildRequest(@NonNull spark.Request req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        Request.RequestBuilder builder = Request.builder().req(req).path(req.pathInfo()).origin(req.scheme() + "://" + req.host());
        XObj header = new XObj();
        builder.header(header);
        try {
            req.headers().forEach(key -> {
                String value = req.headers(key);
                header.put(key, (Object)value);
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        XObj query = new XObj();
        builder.query(query);
        try {
            XSeq.forEach((Object[])req.queryString().split("&"), (XConsumer & Serializable)e -> {
                String[] arrKeyValue = e.split("=", 2);
                query.put((Object)arrKeyValue[0], (Object)arrKeyValue[1]);
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        XObj attribute = new XObj();
        builder.attribute(attribute);
        try {
            req.attributes().forEach(key -> {
                Object value = req.attribute(key);
                attribute.put(key, value);
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            req.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement("/temp"));
            Collection parts = req.raw().getParts();
            if (parts != null) {
                builder.collPart(parts);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            builder.body(XObj.fromObject((Object)req.body()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object buildResult(@NonNull spark.Request req, @NonNull spark.Response resp, XFunction<Request, Object> processReq, XFunction2<Request, Response, Object> processReqResp) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        if (resp == null) {
            throw new NullPointerException("resp is marked non-null but is null");
        }
        Response response = this.buildResponse(req, resp);
        Request request = this.buildRequest(req);
        String nameMetric = String.format("%s:%s", req.requestMethod(), req.matchedPath()).toLowerCase().replace("*", "").replace("-", "_").replace("/", ":");
        try (XProfileTimer timer = this.isProfiler != false ? this.objProfiler.getTimer(nameMetric) : null;){
            Object result = null;
            if (processReq != null) {
                result = processReq.apply((Object)request);
            }
            if (processReqResp != null) {
                result = processReqResp.apply((Object)request, (Object)response);
            }
            if (result == null) {
                String string = "";
                return string;
            }
            if (result instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)result;
                return httpServletResponse;
            }
            String strResult = result.toString();
            XObj header = response.getHeader();
            header.entrySet().forEach(entry -> resp.header(entry.getKey().toString(), entry.getValue().toString()));
            String type = resp.raw().getHeader("Content-Type");
            if (type != null) {
                String string = strResult;
                return string;
            }
            XJson.fromStr((String)strResult, XObj.class);
            resp.header("Content-Type", "application/json");
            String string = strResult;
            return string;
        }
        catch (HaltException e) {
            throw e;
        }
        catch (Throwable e) {
            XLog.error((Object)e);
            throw this.halt(XRestStatus.INTERNAL_SERVER_ERROR, XEx.getStackTrace((Throwable)e));
        }
    }

    public Object checkNotNull(@NonNull Object obj, String ... arrKey) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (arrKey == null) {
            throw new NullPointerException("arrKey is marked non-null but is null");
        }
        try {
            return XEx.checkFieldNotNull((Object)obj, (String[])arrKey);
        }
        catch (Throwable e) {
            throw this.halt(XRestStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public RuntimeException halt(@NonNull Integer codeStatus) {
        if (codeStatus == null) {
            throw new NullPointerException("codeStatus is marked non-null but is null");
        }
        return this.halt(codeStatus, "");
    }

    public RuntimeException halt(@NonNull Integer codeStatus, @NonNull Object body) {
        if (codeStatus == null) {
            throw new NullPointerException("codeStatus is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        String bodyStr = body.toString();
        this.service.halt(codeStatus.intValue(), bodyStr);
        return new RuntimeException("halt " + codeStatus + ": " + bodyStr);
    }

    public void match(String path, @NonNull XConsumer<String> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        path = XRestServer.processPath(path);
        XSeq.newArrayList((Object[])new String[]{path, path + "/"}).forEach(arg_0 -> func.accept(arg_0));
    }

    public void all(@NonNull XConsumer<String> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        this.all("", func);
    }

    public void all(@NonNull String path, @NonNull XConsumer<String> func) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.newArrayList((Object[])new String[]{"", "/*"}).forEach(p -> func.accept((Object)(path + p)));
    }

    public void path(@NonNull String path, @NonNull Runnable func) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        this.match(path, (XConsumer<String>)(XConsumer & Serializable)p -> this.service.path(p, func::run));
    }

    public void before(@NonNull XConsumer<Request> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        this.before("", func);
    }

    public void before(@NonNull String path, @NonNull XConsumer<Request> func) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        this.match(path, (XConsumer<String>)(XConsumer & Serializable)p -> this.service.before(p, (req, resp) -> {
            try {
                func.accept((Object)this.buildRequest(req));
            }
            catch (HaltException e) {
                this.halt(e.statusCode(), e.body());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }));
    }

    void request(@NonNull RequestParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        this.match(param.getPath(), (XConsumer<String>)(XConsumer & Serializable)path -> param.getMethod().accept(path, (req, resp) -> this.buildResult(req, resp, param.getProcessReq(), param.getProcessReqResp())));
    }

    public void head(@NonNull XFunction<Request, Object> processReq) {
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.head(x$0, x$1)).processReq(processReq).build());
    }

    public void head(@NonNull String path, @NonNull XFunction<Request, Object> processReq) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.head(x$0, x$1)).path(path).processReq(processReq).build());
    }

    public void head(@NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.head(x$0, x$1)).processReqResp(processReqResp).build());
    }

    public void head(@NonNull String path, @NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.head(x$0, x$1)).path(path).processReqResp(processReqResp).build());
    }

    public void option(@NonNull XFunction<Request, Object> processReq) {
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.options(x$0, x$1)).processReq(processReq).build());
    }

    public void option(@NonNull String path, @NonNull XFunction<Request, Object> processReq) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.options(x$0, x$1)).path(path).processReq(processReq).build());
    }

    public void option(@NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.options(x$0, x$1)).processReqResp(processReqResp).build());
    }

    public void option(@NonNull String path, @NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.options(x$0, x$1)).path(path).processReqResp(processReqResp).build());
    }

    public void get(@NonNull XFunction<Request, Object> processReq) {
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.get(x$0, x$1)).processReq(processReq).build());
    }

    public void get(@NonNull String path, @NonNull XFunction<Request, Object> processReq) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.get(x$0, x$1)).path(path).processReq(processReq).build());
    }

    public void get(@NonNull @NonNull XFunction2<Request, @NonNull Response, Object> processReqResp) {
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.get(x$0, x$1)).processReqResp(processReqResp).build());
    }

    public void get(@NonNull String path, @NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.get(x$0, x$1)).path(path).processReqResp(processReqResp).build());
    }

    public void post(@NonNull XFunction<Request, Object> processReq) {
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.post(x$0, x$1)).processReq(processReq).build());
    }

    public void post(@NonNull String path, @NonNull XFunction<Request, Object> processReq) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.post(x$0, x$1)).path(path).processReq(processReq).build());
    }

    public void post(@NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.post(x$0, x$1)).processReqResp(processReqResp).build());
    }

    public void post(@NonNull String path, @NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.post(x$0, x$1)).path(path).processReqResp(processReqResp).build());
    }

    public void put(@NonNull XFunction<Request, Object> processReq) {
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.put(x$0, x$1)).processReq(processReq).build());
    }

    public void put(@NonNull String path, @NonNull XFunction<Request, Object> processReq) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.put(x$0, x$1)).path(path).processReq(processReq).build());
    }

    public void put(@NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.put(x$0, x$1)).processReqResp(processReqResp).build());
    }

    public void put(@NonNull String path, @NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.put(x$0, x$1)).path(path).processReqResp(processReqResp).build());
    }

    public void delete(@NonNull XFunction<Request, Object> processReq) {
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.delete(x$0, x$1)).processReq(processReq).build());
    }

    public void delete(@NonNull String path, @NonNull XFunction<Request, Object> processReq) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReq == null) {
            throw new NullPointerException("processReq is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.delete(x$0, x$1)).path(path).processReq(processReq).build());
    }

    public void delete(@NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.delete(x$0, x$1)).processReqResp(processReqResp).build());
    }

    public void delete(@NonNull String path, @NonNull XFunction2<Request, Response, Object> processReqResp) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (processReqResp == null) {
            throw new NullPointerException("processReqResp is marked non-null but is null");
        }
        this.request(RequestParam.builder().method((XConsumer2<String, Route>)(XConsumer2 & Serializable)(x$0, x$1) -> this.service.delete(x$0, x$1)).path(path).processReqResp(processReqResp).build());
    }

    public void close() {
        this.service.stop();
        this.service.awaitStop();
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getNumThread() {
        return this.numThread;
    }

    public String getPathStatic() {
        return this.pathStatic;
    }

    public Boolean getIsProfiler() {
        return this.isProfiler;
    }

    XProfileObj getObjProfiler() {
        return this.objProfiler;
    }

    static class RequestParam {
        @NonNull
        transient XConsumer2<String, Route> method;
        String path;
        transient XFunction<Request, Object> processReq;
        transient XFunction2<Request, Response, Object> processReqResp;

        RequestParam(@NonNull XConsumer2<String, Route> method, String path, XFunction<Request, Object> processReq, XFunction2<Request, Response, Object> processReqResp) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            this.path = path;
            this.processReq = processReq;
            this.processReqResp = processReqResp;
        }

        public static RequestParamBuilder builder() {
            return new RequestParamBuilder();
        }

        @NonNull
        public XConsumer2<String, Route> getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public XFunction<Request, Object> getProcessReq() {
            return this.processReq;
        }

        public XFunction2<Request, Response, Object> getProcessReqResp() {
            return this.processReqResp;
        }

        public static class RequestParamBuilder {
            private XConsumer2<String, Route> method;
            private String path;
            private XFunction<Request, Object> processReq;
            private XFunction2<Request, Response, Object> processReqResp;

            RequestParamBuilder() {
            }

            public RequestParamBuilder method(@NonNull XConsumer2<String, Route> method) {
                if (method == null) {
                    throw new NullPointerException("method is marked non-null but is null");
                }
                this.method = method;
                return this;
            }

            public RequestParamBuilder path(String path) {
                this.path = path;
                return this;
            }

            public RequestParamBuilder processReq(XFunction<Request, Object> processReq) {
                this.processReq = processReq;
                return this;
            }

            public RequestParamBuilder processReqResp(XFunction2<Request, Response, Object> processReqResp) {
                this.processReqResp = processReqResp;
                return this;
            }

            public RequestParam build() {
                return new RequestParam(this.method, this.path, this.processReq, this.processReqResp);
            }

            public String toString() {
                return "XRestServer.RequestParam.RequestParamBuilder(method=" + this.method + ", path=" + this.path + ", processReq=" + this.processReq + ", processReqResp=" + this.processReqResp + ")";
            }
        }
    }

    public static final class Response {
        @NonNull
        transient Service service;
        @NonNull
        transient spark.Request req;
        @NonNull
        transient spark.Response resp;
        XObj header;

        public HttpServletResponse serve(@NonNull String pathFile) {
            if (pathFile == null) {
                throw new NullPointerException("pathFile is marked non-null but is null");
            }
            try {
                if (!XFile.isfile((String)pathFile)) {
                    this.service.halt(404, "No file: " + pathFile);
                }
                String range = this.req.headers("Range");
                File file = new File(pathFile);
                long total = file.length();
                this.resp.header("Accept-Ranges", "bytes");
                this.resp.header("Content-Type", XFile.mime((Object)pathFile));
                HttpServletResponse raw = this.resp.raw();
                if (XStr.isEmpty((String)range)) {
                    this.resp.header("Content-Length", XCls.toStr((Object)total));
                    XFile.cp((Object)pathFile, (Object)raw.getOutputStream());
                } else {
                    String[] arrPartRange = range.split("=")[1].split("-");
                    int start = XCls.toInt((Object)arrPartRange[0]);
                    int end = -1;
                    if (arrPartRange.length == 2) {
                        try {
                            end = XCls.toInt((Object)arrPartRange[1]);
                        }
                        catch (Throwable e) {
                            this.service.halt(416, "Get end fail: " + e);
                        }
                        if ((long)end >= total) {
                            this.service.halt(416, String.format("End >= total: %s > %s", end, total));
                        }
                    } else {
                        end = start + 1048575;
                        if ((long)end > total) {
                            end = XCls.toInt((Object)(total - 1L));
                        }
                    }
                    if (start > end) {
                        this.service.halt(416, String.format("Start > end: %s > %s", start, total));
                    }
                    if ((long)start >= total) {
                        this.service.halt(416, String.format("Start >= total: %s > %s", start, total));
                    }
                    int length = end - start + 1;
                    this.resp.status(206);
                    this.resp.header("Content-Range", String.format("bytes %s-%s/%s", start, end, total));
                    this.resp.header("Content-Length", XCls.toStr((Object)length));
                    try (RandomAccessFile fileSlice = new RandomAccessFile(file, "r");){
                        fileSlice.seek(start);
                        try (BufferedInputStream streamInput = new BufferedInputStream(new FileInputStream(fileSlice.getFD()));
                             BufferedOutputStream streamOutput = new BufferedOutputStream((OutputStream)raw.getOutputStream());){
                            int b = -1;
                            int count = 0;
                            while ((b = ((InputStream)streamInput).read()) > -1) {
                                ((OutputStream)streamOutput).write(b);
                                if (++count != length) continue;
                            }
                            ((OutputStream)streamOutput).flush();
                        }
                    }
                }
                return raw;
            }
            catch (HaltException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        Response(@NonNull Service service, @NonNull spark.Request req, @NonNull spark.Response resp, XObj header) {
            if (service == null) {
                throw new NullPointerException("service is marked non-null but is null");
            }
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (resp == null) {
                throw new NullPointerException("resp is marked non-null but is null");
            }
            this.service = service;
            this.req = req;
            this.resp = resp;
            this.header = header;
        }

        static ResponseBuilder builder() {
            return new ResponseBuilder();
        }

        @NonNull
        Service getService() {
            return this.service;
        }

        @NonNull
        spark.Request getReq() {
            return this.req;
        }

        @NonNull
        spark.Response getResp() {
            return this.resp;
        }

        public XObj getHeader() {
            return this.header;
        }

        static class ResponseBuilder {
            private Service service;
            private spark.Request req;
            private spark.Response resp;
            private XObj header;

            ResponseBuilder() {
            }

            ResponseBuilder service(@NonNull Service service) {
                if (service == null) {
                    throw new NullPointerException("service is marked non-null but is null");
                }
                this.service = service;
                return this;
            }

            ResponseBuilder req(@NonNull spark.Request req) {
                if (req == null) {
                    throw new NullPointerException("req is marked non-null but is null");
                }
                this.req = req;
                return this;
            }

            ResponseBuilder resp(@NonNull spark.Response resp) {
                if (resp == null) {
                    throw new NullPointerException("resp is marked non-null but is null");
                }
                this.resp = resp;
                return this;
            }

            ResponseBuilder header(XObj header) {
                this.header = header;
                return this;
            }

            Response build() {
                return new Response(this.service, this.req, this.resp, this.header);
            }

            public String toString() {
                return "XRestServer.Response.ResponseBuilder(service=" + this.service + ", req=" + this.req + ", resp=" + this.resp + ", header=" + this.header + ")";
            }
        }
    }

    public static final class Request {
        @NonNull
        transient spark.Request req;
        @NonNull
        String origin;
        @NonNull
        String path;
        XObj query;
        XObj header;
        XObj body;
        XObj attribute;
        transient Collection<Part> collPart;

        public void setAttribute(@NonNull String key, Object value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.attribute.put((Object)key, value);
            this.req.attribute(key, value);
        }

        public List<String> store(@NonNull String pathDir) {
            if (pathDir == null) {
                throw new NullPointerException("pathDir is marked non-null but is null");
            }
            ArrayList<String> lsNameFile = new ArrayList<String>(this.collPart.size());
            XFile.mkdir((String)pathDir);
            this.collPart.forEach(part -> {
                try {
                    String nameFile = part.getSubmittedFileName();
                    if (nameFile == null) {
                        return;
                    }
                    String pathFile = XStr.join((Object)"/", (Object[])new Object[]{pathDir, nameFile});
                    XFile.cp((Object)part.getInputStream(), (Object)pathFile);
                    lsNameFile.add(nameFile);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            return lsNameFile;
        }

        Request(@NonNull spark.Request req, @NonNull String origin, @NonNull String path, XObj query, XObj header, XObj body, XObj attribute, Collection<Part> collPart) {
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (origin == null) {
                throw new NullPointerException("origin is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.req = req;
            this.origin = origin;
            this.path = path;
            this.query = query;
            this.header = header;
            this.body = body;
            this.attribute = attribute;
            this.collPart = collPart;
        }

        static RequestBuilder builder() {
            return new RequestBuilder();
        }

        @NonNull
        spark.Request getReq() {
            return this.req;
        }

        @NonNull
        public String getOrigin() {
            return this.origin;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        public XObj getQuery() {
            return this.query;
        }

        public XObj getHeader() {
            return this.header;
        }

        public XObj getBody() {
            return this.body;
        }

        public XObj getAttribute() {
            return this.attribute;
        }

        Collection<Part> getCollPart() {
            return this.collPart;
        }

        static class RequestBuilder {
            private spark.Request req;
            private String origin;
            private String path;
            private XObj query;
            private XObj header;
            private XObj body;
            private XObj attribute;
            private Collection<Part> collPart;

            RequestBuilder() {
            }

            RequestBuilder req(@NonNull spark.Request req) {
                if (req == null) {
                    throw new NullPointerException("req is marked non-null but is null");
                }
                this.req = req;
                return this;
            }

            RequestBuilder origin(@NonNull String origin) {
                if (origin == null) {
                    throw new NullPointerException("origin is marked non-null but is null");
                }
                this.origin = origin;
                return this;
            }

            RequestBuilder path(@NonNull String path) {
                if (path == null) {
                    throw new NullPointerException("path is marked non-null but is null");
                }
                this.path = path;
                return this;
            }

            RequestBuilder query(XObj query) {
                this.query = query;
                return this;
            }

            RequestBuilder header(XObj header) {
                this.header = header;
                return this;
            }

            RequestBuilder body(XObj body) {
                this.body = body;
                return this;
            }

            RequestBuilder attribute(XObj attribute) {
                this.attribute = attribute;
                return this;
            }

            RequestBuilder collPart(Collection<Part> collPart) {
                this.collPart = collPart;
                return this;
            }

            Request build() {
                return new Request(this.req, this.origin, this.path, this.query, this.header, this.body, this.attribute, this.collPart);
            }

            public String toString() {
                return "XRestServer.Request.RequestBuilder(req=" + this.req + ", origin=" + this.origin + ", path=" + this.path + ", query=" + this.query + ", header=" + this.header + ", body=" + this.body + ", attribute=" + this.attribute + ", collPart=" + this.collPart + ")";
            }
        }
    }
}

