/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.jgit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;
import org.joda.time.ReadableInstant;
import pl.project13.jgit.dummy.DatedRevTag;
import pl.project13.maven.git.log.LoggerBridge;

public class JGitCommon {
    private final LoggerBridge log;

    public JGitCommon(LoggerBridge log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getTags(Repository repo, final ObjectId headId) throws GitAPIException {
        RevWalk walk = null;
        try {
            Collection tags;
            Git git = Git.wrap((Repository)repo);
            walk = new RevWalk(repo);
            List tagRefs = git.tagList().call();
            final RevWalk finalWalk = walk;
            Collection tagsForHeadCommit = Collections2.filter((Collection)tagRefs, (Predicate)new Predicate<Ref>(){

                public boolean apply(Ref tagRef) {
                    boolean lightweightTag = tagRef.getObjectId().equals((AnyObjectId)headId);
                    try {
                        return lightweightTag || finalWalk.parseTag((AnyObjectId)tagRef.getObjectId()).getObject().getId().equals((AnyObjectId)headId);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            });
            Collection collection = tags = Collections2.transform((Collection)tagsForHeadCommit, (Function)new Function<Ref, String>(){

                public String apply(Ref input) {
                    return input.getName().replaceAll("refs/tags/", "");
                }
            });
            return collection;
        }
        finally {
            if (walk != null) {
                walk.dispose();
            }
        }
    }

    public String getClosestTagName(@NotNull Repository repo) {
        Map<ObjectId, List<DatedRevTag>> map = this.getClosestTagAsMap(repo);
        Iterator<Map.Entry<ObjectId, List<DatedRevTag>>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<ObjectId, List<DatedRevTag>> entry = iterator.next();
            return this.trimFullTagName(entry.getValue().get((int)0).tagName);
        }
        return "";
    }

    public String getClosestTagCommitCount(@NotNull Repository repo, RevCommit headCommit) {
        HashMap<ObjectId, List<String>> map = this.transformRevTagsMapToDateSortedTagNames(this.getClosestTagAsMap(repo));
        ObjectId obj = (ObjectId)map.keySet().toArray()[0];
        RevWalk walk = new RevWalk(repo);
        RevCommit commit = walk.lookupCommit((AnyObjectId)obj);
        walk.dispose();
        int distance = this.distanceBetween(repo, headCommit, commit);
        return String.valueOf(distance);
    }

    private Map<ObjectId, List<DatedRevTag>> getClosestTagAsMap(@NotNull Repository repo) {
        HashMap<ObjectId, List<DatedRevTag>> mapWithClosestTagOnly;
        block0: {
            mapWithClosestTagOnly = new HashMap<ObjectId, List<DatedRevTag>>();
            String matchPattern = ".*";
            Map<ObjectId, List<DatedRevTag>> commitIdsToTags = this.getCommitIdsToTags(repo, true, matchPattern);
            LinkedHashMap<ObjectId, List<DatedRevTag>> sortedCommitIdsToTags = this.sortByDatedRevTag(commitIdsToTags);
            Iterator<Map.Entry<ObjectId, List<DatedRevTag>>> iterator = sortedCommitIdsToTags.entrySet().iterator();
            if (!iterator.hasNext()) break block0;
            Map.Entry<ObjectId, List<DatedRevTag>> entry = iterator.next();
            mapWithClosestTagOnly.put(entry.getKey(), entry.getValue());
        }
        return mapWithClosestTagOnly;
    }

    private LinkedHashMap<ObjectId, List<DatedRevTag>> sortByDatedRevTag(Map<ObjectId, List<DatedRevTag>> map) {
        ArrayList<Map.Entry<ObjectId, List<DatedRevTag>>> list = new ArrayList<Map.Entry<ObjectId, List<DatedRevTag>>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<ObjectId, List<DatedRevTag>>>(){

            @Override
            public int compare(Map.Entry<ObjectId, List<DatedRevTag>> m1, Map.Entry<ObjectId, List<DatedRevTag>> m2) {
                Collections.sort(m1.getValue(), JGitCommon.this.datedRevTagComparator());
                Collections.sort(m2.getValue(), JGitCommon.this.datedRevTagComparator());
                DatedRevTag datedRevTag1 = m1.getValue().get(0);
                DatedRevTag datedRevTag2 = m2.getValue().get(0);
                return JGitCommon.this.datedRevTagComparator().compare(datedRevTag1, datedRevTag2);
            }
        });
        LinkedHashMap<ObjectId, List<DatedRevTag>> result = new LinkedHashMap<ObjectId, List<DatedRevTag>>();
        for (Map.Entry entry : list) {
            result.put((ObjectId)entry.getKey(), (List<DatedRevTag>)entry.getValue());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<ObjectId, List<DatedRevTag>> getCommitIdsToTags(@NotNull Repository repo, boolean includeLightweightTags, String matchPattern) {
        HashMap<ObjectId, ArrayList<DatedRevTag>> commitIdsToTags = new HashMap<ObjectId, ArrayList<DatedRevTag>>();
        try (RevWalk walk = new RevWalk(repo);){
            walk.markStart(walk.parseCommit((AnyObjectId)repo.resolve("HEAD")));
            List tagRefs = Git.wrap((Repository)repo).tagList().call();
            Pattern regex = Pattern.compile(matchPattern);
            this.log.info("Tag refs [{}]", (Object)tagRefs);
            for (Ref ref : tagRefs) {
                walk.reset();
                String name = ref.getName();
                if (!regex.matcher(name).matches()) {
                    this.log.info("Skipping tagRef with name [{}] as it doesn't match [{}]", (Object)name, (Object)matchPattern);
                    continue;
                }
                ObjectId resolvedCommitId = repo.resolve(name);
                try {
                    RevTag revTag = walk.parseTag((AnyObjectId)resolvedCommitId);
                    ObjectId taggedCommitId = revTag.getObject().getId();
                    this.log.info("Resolved tag [{}] [{}], points at [{}] ", revTag.getTagName(), revTag.getTaggerIdent(), taggedCommitId);
                    while (this.isTagId(taggedCommitId)) {
                        taggedCommitId = walk.parseTag((AnyObjectId)taggedCommitId).getObject().getId();
                    }
                    if (commitIdsToTags.containsKey(taggedCommitId)) {
                        ((List)commitIdsToTags.get(taggedCommitId)).add(new DatedRevTag(revTag));
                        continue;
                    }
                    commitIdsToTags.put(taggedCommitId, new ArrayList<DatedRevTag>(Collections.singletonList(new DatedRevTag(revTag))));
                }
                catch (IncorrectObjectTypeException ex) {
                    if (!includeLightweightTags) continue;
                    this.log.info("Including lightweight tag [{}]", (Object)name);
                    DatedRevTag datedRevTag = new DatedRevTag((AnyObjectId)resolvedCommitId, name);
                    if (commitIdsToTags.containsKey(resolvedCommitId)) {
                        ((List)commitIdsToTags.get(resolvedCommitId)).add(datedRevTag);
                        continue;
                    }
                    commitIdsToTags.put(resolvedCommitId, new ArrayList<DatedRevTag>(Collections.singletonList(datedRevTag)));
                }
                catch (Exception ignored) {
                    this.log.info("Failed while parsing [{}] -- ", (Object)ref, (Object)ignored);
                }
            }
            for (Map.Entry entry : commitIdsToTags.entrySet()) {
                this.log.info("key [{}], tags => [{}] ", entry.getKey(), entry.getValue());
            }
            HashMap<ObjectId, ArrayList<DatedRevTag>> hashMap = commitIdsToTags;
            return hashMap;
        }
        catch (Exception e) {
            this.log.info("Unable to locate tags", e);
            return Collections.emptyMap();
        }
    }

    private boolean isTagId(ObjectId objectId) {
        return objectId.toString().startsWith("tag ");
    }

    protected HashMap<ObjectId, List<String>> transformRevTagsMapToDateSortedTagNames(Map<ObjectId, List<DatedRevTag>> commitIdsToTags) {
        HashMap<ObjectId, List<String>> commitIdsToTagNames = new HashMap<ObjectId, List<String>>();
        for (Map.Entry<ObjectId, List<DatedRevTag>> objectIdListEntry : commitIdsToTags.entrySet()) {
            List<String> tagNames = this.transformRevTagsMapEntryToDateSortedTagNames(objectIdListEntry);
            commitIdsToTagNames.put(objectIdListEntry.getKey(), tagNames);
        }
        return commitIdsToTagNames;
    }

    private List<String> transformRevTagsMapEntryToDateSortedTagNames(Map.Entry<ObjectId, List<DatedRevTag>> objectIdListEntry) {
        List<DatedRevTag> tags = objectIdListEntry.getValue();
        ArrayList<DatedRevTag> newTags = new ArrayList<DatedRevTag>(tags);
        Collections.sort(newTags, this.datedRevTagComparator());
        List tagNames = Lists.transform(newTags, (Function)new Function<DatedRevTag, String>(){

            public String apply(DatedRevTag input) {
                return JGitCommon.this.trimFullTagName(input.tagName);
            }
        });
        return tagNames;
    }

    private Comparator<DatedRevTag> datedRevTagComparator() {
        return new Comparator<DatedRevTag>(){

            @Override
            public int compare(DatedRevTag revTag, DatedRevTag revTag2) {
                return revTag2.date.compareTo((ReadableInstant)revTag.date);
            }
        };
    }

    @VisibleForTesting
    protected String trimFullTagName(@NotNull String tagName) {
        return tagName.replaceFirst("refs/tags/", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RevCommit> findCommitsUntilSomeTag(Repository repo, RevCommit head, @NotNull Map<ObjectId, List<String>> tagObjectIdToName) {
        try (RevWalk revWalk = new RevWalk(repo);){
            revWalk.markStart(head);
            for (RevCommit commit : revWalk) {
                List<String> maybeList;
                ObjectId objId = commit.getId();
                if (tagObjectIdToName.size() <= 0 || (maybeList = tagObjectIdToName.get(objId)) == null || maybeList.get(0) == null) continue;
                List<RevCommit> list = Collections.singletonList(commit);
                return list;
            }
            List list = Collections.emptyList();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find commits until some tag", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int distanceBetween(@NotNull Repository repo, @NotNull RevCommit child, @NotNull RevCommit parent) {
        try (RevWalk revWalk = new RevWalk(repo);){
            revWalk.markStart(child);
            HashSet<ObjectId> seena = new HashSet<ObjectId>();
            HashSet<ObjectId> seenb = new HashSet<ObjectId>();
            ArrayDeque<RevCommit> q = new ArrayDeque<RevCommit>();
            q.add(revWalk.parseCommit((AnyObjectId)child));
            int distance = 0;
            ObjectId parentId = parent.getId();
            while (q.size() > 0) {
                RevCommit commit = (RevCommit)q.remove();
                ObjectId commitId = commit.getId();
                if (seena.contains(commitId)) continue;
                seena.add(commitId);
                if (parentId.equals((AnyObjectId)commitId)) {
                    this.seeAllParents(revWalk, commit, seenb);
                    for (ObjectId oid : seenb) {
                        if (!seena.contains(oid)) continue;
                        --distance;
                    }
                    seena.addAll(seenb);
                    continue;
                }
                for (RevCommit oid : commit.getParents()) {
                    if (seena.contains(oid)) continue;
                    q.add(revWalk.parseCommit((AnyObjectId)oid));
                }
                ++distance;
            }
            int n = distance;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to calculate distance between [%s] and [%s]", child, parent), e);
        }
    }

    private void seeAllParents(@NotNull RevWalk revWalk, RevCommit child, @NotNull Set<ObjectId> seen) throws IOException {
        ArrayDeque<RevCommit> q = new ArrayDeque<RevCommit>();
        q.add(child);
        while (q.size() > 0) {
            RevCommit commit = (RevCommit)q.remove();
            for (RevCommit oid : commit.getParents()) {
                if (seen.contains(oid)) continue;
                seen.add((ObjectId)oid);
                q.add(revWalk.parseCommit((AnyObjectId)oid));
            }
        }
    }
}

