/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import javax.net.SocketFactory;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.AbstractTcpConnector;
import rocks.xmpp.core.net.client.SocketConnection;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.net.client.XmppStreamWriter;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;

public final class SocketConnector
extends AbstractTcpConnector<Socket> {
    private final SocketFactory socketFactory;

    public SocketConnector() {
        this(null);
    }

    public SocketConnector(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    protected final CompletableFuture<Socket> connect(String hostname, int port, TcpConnectionConfiguration configuration) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Socket socket = this.socketFactory == null ? (configuration.getProxy() != null ? new Socket(configuration.getProxy()) : new Socket()) : this.socketFactory.createSocket();
                if (!socket.isConnected()) {
                    socket.connect(new InetSocketAddress(hostname, configuration.getPort()), configuration.getConnectTimeout());
                }
                return socket;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, XmppStreamWriter.EXECUTOR);
    }

    @Override
    public final CompletableFuture<Connection> connect(XmppSession xmppSession, TcpConnectionConfiguration configuration, SessionOpen sessionOpen) {
        return this.createConnection(xmppSession, configuration, (socket, config) -> new SocketConnection((Socket)socket, xmppSession, (TcpConnectionConfiguration)config), sessionOpen);
    }
}

