/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.util.XmppStreamEncoder;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;

final class XmppStreamWriter {
    private static final System.Logger logger = System.getLogger(XmppStreamWriter.class.getName());
    static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"Writer Thread"));
    private final XmppSession xmppSession;
    private final Connection connection;
    private final ScheduledExecutorService executor;
    private final List<WriterInterceptor> writerInterceptors = new ArrayList<WriterInterceptor>();
    private OutputStreamWriter outputStreamWriter;
    private boolean streamOpened;

    XmppStreamWriter(Iterable<WriterInterceptor> writerInterceptors, Connection connection, XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.connection = connection;
        writerInterceptors.forEach(this.writerInterceptors::add);
        this.writerInterceptors.add((WriterInterceptor)new XmppStreamEncoder(xmppSession.getConfiguration().getXmlOutputFactory(), xmppSession::createMarshaller, s -> false));
        this.executor = new QueuedScheduledExecutorService((Executor)EXECUTOR);
    }

    void initialize(Duration keepAliveInterval) {
        if (keepAliveInterval != null && !keepAliveInterval.isNegative() && !keepAliveInterval.isZero()) {
            this.executor.scheduleAtFixedRate(() -> {
                if (EnumSet.of(XmppSession.Status.CONNECTED, XmppSession.Status.AUTHENTICATED).contains((Object)this.xmppSession.getStatus())) {
                    try {
                        if (logger.isLoggable(System.Logger.Level.TRACE)) {
                            logger.log(System.Logger.Level.TRACE, "Sending whitespace ping, connection " + System.identityHashCode(this.connection));
                        }
                        this.outputStreamWriter.write(32);
                        this.outputStreamWriter.flush();
                    }
                    catch (Exception e) {
                        this.notifyException(e);
                    }
                }
            }, keepAliveInterval.toSeconds(), keepAliveInterval.toSeconds(), TimeUnit.SECONDS);
        }
    }

    CompletableFuture<Void> write(StreamElement clientStreamElement, boolean flush) {
        Objects.requireNonNull(clientStreamElement);
        return CompletableFuture.runAsync(() -> {
            try {
                WriterInterceptorChain writerInterceptorChain = new WriterInterceptorChain(this.writerInterceptors, (Session)this.xmppSession, this.connection);
                writerInterceptorChain.proceed(clientStreamElement, (Writer)this.outputStreamWriter);
                if (flush) {
                    this.outputStreamWriter.flush();
                }
            }
            catch (Exception e) {
                this.notifyException(e);
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    CompletionStage<Void> openStream(OutputStream outputStream, StreamHeader streamHeader) {
        return CompletableFuture.runAsync(() -> {
            this.outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            try {
                WriterInterceptorChain writerInterceptorChain = new WriterInterceptorChain(this.writerInterceptors, (Session)this.xmppSession, this.connection);
                writerInterceptorChain.proceed((StreamElement)streamHeader, (Writer)this.outputStreamWriter);
                this.outputStreamWriter.flush();
                if (logger.isLoggable(System.Logger.Level.TRACE)) {
                    logger.log(System.Logger.Level.TRACE, "Stream opened for connection " + System.identityHashCode(this.connection));
                }
                this.streamOpened = true;
            }
            catch (Exception e) {
                this.notifyException(e);
            }
        }, this.executor);
    }

    private CompletableFuture<Void> closeStream() {
        return CompletableFuture.runAsync(() -> {
            if (this.streamOpened) {
                try {
                    WriterInterceptorChain writerInterceptorChain = new WriterInterceptorChain(this.writerInterceptors, (Session)this.xmppSession, this.connection);
                    writerInterceptorChain.proceed(StreamHeader.CLOSING_STREAM_TAG, (Writer)this.outputStreamWriter);
                    this.outputStreamWriter.flush();
                    this.outputStreamWriter.close();
                    this.outputStreamWriter = null;
                    this.streamOpened = false;
                    if (logger.isLoggable(System.Logger.Level.TRACE)) {
                        logger.log(System.Logger.Level.TRACE, "Sent closing stream tag, closed stream writer for connection " + System.identityHashCode(this.connection));
                    }
                }
                catch (Exception e) {
                    this.notifyException(e);
                }
            }
        }, this.executor);
    }

    void flush() {
        this.executor.execute(() -> {
            try {
                this.outputStreamWriter.flush();
            }
            catch (IOException e) {
                this.xmppSession.notifyException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Exception exception) {
        XmppStreamWriter xmppStreamWriter = this;
        synchronized (xmppStreamWriter) {
            this.executor.shutdown();
            if (this.outputStreamWriter != null) {
                try {
                    this.outputStreamWriter.close();
                    this.outputStreamWriter = null;
                }
                catch (Exception e) {
                    exception.addSuppressed(e);
                }
            }
        }
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "Got exception, shutdown writer for connection " + System.identityHashCode(this.connection), (Throwable)exception);
        }
        this.xmppSession.notifyException(exception);
    }

    CompletableFuture<Void> shutdown() {
        return this.closeStream().whenCompleteAsync((aVoid, throwable) -> {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                    this.executor.shutdownNow();
                    if (logger.isLoggable(System.Logger.Level.TRACE)) {
                        logger.log(System.Logger.Level.TRACE, "Couldn't shutdown writer executor, shutdown now, for connection " + System.identityHashCode(this.connection));
                    }
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            if (logger.isLoggable(System.Logger.Level.TRACE)) {
                logger.log(System.Logger.Level.TRACE, "Shutdown writer executor for connection " + System.identityHashCode(this.connection));
            }
        });
    }
}

