/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.time.Duration;
import java.util.function.BiPredicate;
import rocks.xmpp.core.session.ReconnectionStrategy;

final class HybridReconnectionStrategy
implements ReconnectionStrategy {
    private final ReconnectionStrategy primaryStrategy;
    private final ReconnectionStrategy secondaryStrategy;
    private final BiPredicate<Integer, Throwable> predicate;

    public HybridReconnectionStrategy(ReconnectionStrategy primaryStrategy, ReconnectionStrategy secondaryStrategy, BiPredicate<Integer, Throwable> predicate) {
        this.primaryStrategy = primaryStrategy;
        this.secondaryStrategy = secondaryStrategy;
        this.predicate = predicate;
    }

    @Override
    public final Duration getNextReconnectionAttempt(int attempt, Throwable cause) {
        return (this.predicate.test(attempt, cause) ? this.primaryStrategy : this.secondaryStrategy).getNextReconnectionAttempt(attempt, cause);
    }
}

