/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream.client;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.tls.model.StartTls;

public final class StreamFeaturesManager
extends Manager
implements StreamHandler {
    private final Map<Class<? extends StreamFeature>, CompletableFuture<Void>> featureNegotiationStartedFutures = new ConcurrentHashMap<Class<? extends StreamFeature>, CompletableFuture<Void>>();
    private final HashMap<Class<? extends StreamFeature>, StreamFeature> advertisedFeatures = new HashMap();
    private final Queue<StreamFeature> featuresToNegotiate = new ArrayDeque<StreamFeature>();
    private final Set<StreamFeatureNegotiator<? extends StreamFeature>> streamFeatureNegotiators = new CopyOnWriteArraySet<StreamFeatureNegotiator<? extends StreamFeature>>();
    private CompletableFuture<Void> negotiationCompleted;
    private CompletableFuture<Void> streamFeaturesReceived;
    private boolean streamWillBeRestarted;

    private StreamFeaturesManager(XmppSession xmppSession) {
        super(xmppSession, false);
    }

    @Override
    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(e -> {
            switch (e.getStatus()) {
                case CONNECTING: {
                    StreamFeaturesManager streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.negotiationCompleted = new CompletableFuture();
                        this.streamFeaturesReceived = new CompletableFuture();
                        this.featureNegotiationStartedFutures.clear();
                        this.advertisedFeatures.clear();
                        break;
                    }
                }
                case CLOSED: {
                    StreamFeaturesManager streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.featureNegotiationStartedFutures.clear();
                        this.advertisedFeatures.clear();
                        this.featuresToNegotiate.clear();
                        this.streamFeatureNegotiators.clear();
                        break;
                    }
                }
            }
        });
    }

    public final Map<Class<? extends StreamFeature>, StreamFeature> getFeatures() {
        return Collections.unmodifiableMap((HashMap)this.advertisedFeatures.clone());
    }

    public final <T> List<T> getFeatures(Class<T> clazz) {
        return this.advertisedFeatures.values().stream().filter(extension -> clazz.isAssignableFrom(extension.getClass())).map(extension -> extension).collect(Collectors.toUnmodifiableList());
    }

    public final void addFeatureNegotiator(StreamFeatureNegotiator<? extends StreamFeature> streamFeatureNegotiator) {
        this.streamFeatureNegotiators.add(streamFeatureNegotiator);
    }

    public final void removeFeatureNegotiator(StreamFeatureNegotiator<? extends StreamFeature> streamFeatureNegotiator) {
        this.streamFeatureNegotiators.remove(streamFeatureNegotiator);
    }

    public final synchronized void processFeatures(StreamFeatures featuresElement) throws StreamNegotiationException {
        this.streamWillBeRestarted = false;
        this.streamFeaturesReceived.complete(null);
        List featureList = featuresElement.getFeatures();
        this.featuresToNegotiate.clear();
        featureList.stream().filter(feature -> feature instanceof StreamFeature).sorted().forEach(feature -> {
            StreamFeature f = (StreamFeature)feature;
            this.advertisedFeatures.put(f.getClass(), f);
            this.featuresToNegotiate.add(f);
        });
        if (featureList.size() == 1 && featureList.get(0) instanceof StartTls) {
            ((StartTls)featureList.get(0)).setMandatory(true);
        }
        this.negotiateNextFeature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleElement(Object element) throws StreamNegotiationException {
        for (StreamFeatureNegotiator<? extends StreamFeature> streamFeatureNegotiator : this.streamFeatureNegotiators) {
            StreamFeaturesManager streamFeaturesManager;
            StreamNegotiationResult streamNegotiationResult = streamFeatureNegotiator.processNegotiation(element);
            if (streamNegotiationResult != StreamNegotiationResult.IGNORE && element instanceof StreamFeature) {
                streamFeaturesManager = this;
                synchronized (streamFeaturesManager) {
                    this.streamWillBeRestarted = ((StreamFeature)element).requiresRestart();
                }
            }
            switch (streamNegotiationResult) {
                case RESTART: {
                    streamFeaturesManager = this;
                    synchronized (streamFeaturesManager) {
                        this.featuresToNegotiate.clear();
                        this.streamWillBeRestarted = false;
                    }
                    return true;
                }
                case SUCCESS: {
                    break;
                }
                case INCOMPLETE: {
                    return false;
                }
            }
        }
        this.negotiateNextFeature();
        return false;
    }

    private synchronized void negotiateNextFeature() throws StreamNegotiationException {
        StreamFeature advertisedFeature = this.featuresToNegotiate.poll();
        if (advertisedFeature != null) {
            CompletableFuture streamFuture = this.featureNegotiationStartedFutures.computeIfAbsent(advertisedFeature.getClass(), k -> new CompletableFuture());
            if (!streamFuture.isDone()) {
                this.handleElement(advertisedFeature);
                streamFuture.complete(null);
            } else {
                this.negotiateNextFeature();
            }
        } else if (!this.streamWillBeRestarted && this.streamFeaturesReceived.isDone()) {
            for (CompletableFuture<Void> condition : this.featureNegotiationStartedFutures.values()) {
                condition.complete(null);
            }
            this.featureNegotiationStartedFutures.clear();
            if (this.negotiationCompleted != null) {
                this.negotiationCompleted.complete(null);
            }
        }
    }

    public final Future<Void> awaitNegotiation(Class<? extends StreamFeature> streamFeature) {
        return this.featureNegotiationStartedFutures.computeIfAbsent(streamFeature, k -> new CompletableFuture());
    }

    public final synchronized Future<Void> completeNegotiation() throws StreamNegotiationException {
        this.negotiateNextFeature();
        return this.negotiationCompleted;
    }

    public void cancelNegotiation() {
        for (Future future : this.featureNegotiationStartedFutures.values()) {
            future.cancel(false);
        }
        this.featureNegotiationStartedFutures.clear();
    }
}

