/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.tls.client;

import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.TcpConnection;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.tls.model.Failure;
import rocks.xmpp.core.tls.model.Proceed;
import rocks.xmpp.core.tls.model.StartTls;

public final class StartTlsManager
implements StreamFeatureNegotiator<StartTls> {
    private final TcpConnection tcpConnection;
    private final ChannelEncryption channelEncryption;
    private final Session session;

    public StartTlsManager(Session session, TcpConnection tcpConnection, ChannelEncryption channelEncryption) {
        this.session = session;
        this.tcpConnection = tcpConnection;
        this.channelEncryption = channelEncryption;
    }

    public StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        if (element instanceof StartTls) {
            StartTls startTls = (StartTls)element;
            if (startTls.isMandatory() && this.channelEncryption == ChannelEncryption.DISABLED) {
                throw new StreamNegotiationException("The server requires TLS, but you disabled it.");
            }
            if (this.channelEncryption == ChannelEncryption.OPTIONAL || this.channelEncryption == ChannelEncryption.REQUIRED) {
                this.session.send((StreamElement)new StartTls());
                return StreamNegotiationResult.INCOMPLETE;
            }
            return StreamNegotiationResult.IGNORE;
        }
        if (element instanceof Proceed) {
            try {
                this.tcpConnection.secureConnection();
            }
            catch (Exception e) {
                throw new StreamNegotiationException((Throwable)e);
            }
            return StreamNegotiationResult.RESTART;
        }
        if (element instanceof Failure) {
            throw new StreamNegotiationException("Failure during TLS negotiation.");
        }
        return StreamNegotiationResult.IGNORE;
    }
}

