/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.nio.ByteBuffer;
import java.util.Objects;
import rocks.xmpp.dns.ResourceRecord;

public final class SrvRecord
implements Comparable<SrvRecord> {
    private final int priority;
    private final int weight;
    private final int port;
    private final String target;

    SrvRecord(ByteBuffer data) {
        this(data.getShort() & 0xFFFF, data.getShort() & 0xFFFF, data.getShort() & 0xFFFF, ResourceRecord.parse(data));
    }

    public SrvRecord(int priority, int weight, int port, String target) {
        this.priority = priority;
        this.weight = weight;
        this.port = port;
        this.target = target;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getWeight() {
        return this.weight;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getTarget() {
        return this.target;
    }

    @Override
    public final int compareTo(SrvRecord o) {
        if (o == null) {
            return -1;
        }
        int result = Integer.compare(this.priority, o.priority);
        if (result == 0 && (result = Integer.compare(this.weight, o.weight)) == 0 && (result = Integer.compare(this.port, o.port)) == 0) {
            result = this.target.compareTo(o.target);
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SrvRecord)) {
            return false;
        }
        SrvRecord other = (SrvRecord)o;
        return this.priority == other.priority && this.weight == other.weight && this.port == other.port && Objects.equals(this.target, other.target);
    }

    public final int hashCode() {
        return Objects.hash(this.priority, this.weight, this.port, this.target);
    }

    public final String toString() {
        return "SRV " + this.priority + " " + this.weight + " " + this.port + " " + this.target;
    }
}

