/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps.client;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.OutboundPresenceHandler;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.caps.AbstractEntityCapabilitiesProtocol;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.disco.client.ClientServiceDiscoveryManager;
import rocks.xmpp.im.subscription.PresenceManager;

public final class ClientEntityCapabilitiesSupport
implements OutboundPresenceHandler {
    private final AbstractEntityCapabilitiesProtocol<? extends EntityCapabilities> entityCapabilitiesProtocol;

    public ClientEntityCapabilitiesSupport(XmppSession xmppSession, AbstractEntityCapabilitiesProtocol<? extends EntityCapabilities> entityCapabilitiesProtocol) {
        this.entityCapabilitiesProtocol = entityCapabilitiesProtocol;
        xmppSession.getManager(ClientServiceDiscoveryManager.class).addCapabilitiesChangeListener(evt -> {
            PresenceManager presenceManager = xmppSession.getManager(PresenceManager.class);
            Presence lastPresence = presenceManager.getLastSentPresence();
            if (lastPresence != null) {
                entityCapabilitiesProtocol.publishCapsNode();
                xmppSession.send((StreamElement)new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null));
            }
        });
        xmppSession.addSessionStatusListener(e -> {
            List serverCapabilities;
            if (e.getStatus() == XmppSession.Status.AUTHENTICATED && !(serverCapabilities = xmppSession.getManager(StreamFeaturesManager.class).getFeatures(entityCapabilitiesProtocol.getEntityCapabilitiesClass())).isEmpty()) {
                entityCapabilitiesProtocol.handleEntityCapabilities((EntityCapabilities)serverCapabilities.get(0), xmppSession.getDomain());
            }
        });
    }

    public final void handleOutboundPresence(PresenceEvent e) {
        Presence presence = e.getPresence();
        if (presence.isAvailable()) {
            if (this.entityCapabilitiesProtocol.getPublishedNodes().isEmpty()) {
                this.entityCapabilitiesProtocol.publishCapsNode();
            }
            ArrayDeque publishedEntityCaps = new ArrayDeque(this.entityCapabilitiesProtocol.getPublishedNodes().values());
            EntityCapabilities lastPublishedEntityCaps = (EntityCapabilities)publishedEntityCaps.getLast();
            presence.putExtension((Object)lastPublishedEntityCaps);
        }
    }
}

