/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.net.Proxy;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.net.client.TransportConnector;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.extensions.httpbind.HttpUrlConnector;

public final class BoshConnectionConfiguration
extends ClientConnectionConfiguration {
    private static volatile BoshConnectionConfiguration defaultConfiguration;
    private final Duration wait;
    private final String path;
    private final String route;
    private final boolean useKeySequence;
    private final TransportConnector<BoshConnectionConfiguration> connector;

    private BoshConnectionConfiguration(Builder builder) {
        super(builder);
        this.wait = builder.wait;
        this.path = builder.path;
        this.route = builder.route;
        this.useKeySequence = builder.useKeySequence;
        this.connector = builder.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BoshConnectionConfiguration getDefault() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<BoshConnectionConfiguration> clazz = BoshConnectionConfiguration.class;
        synchronized (BoshConnectionConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = BoshConnectionConfiguration.builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(BoshConnectionConfiguration configuration) {
        Class<BoshConnectionConfiguration> clazz = BoshConnectionConfiguration.class;
        synchronized (BoshConnectionConfiguration.class) {
            defaultConfiguration = configuration;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final CompletableFuture<Connection> createConnection(XmppSession xmppSession, SessionOpen sessionOpen) {
        if (this.connector == null) {
            return new HttpUrlConnector().connect(xmppSession, this, sessionOpen);
        }
        return this.connector.connect(xmppSession, this, sessionOpen);
    }

    public final Duration getWait() {
        return this.wait;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getRoute() {
        return this.route;
    }

    public final boolean isUseKeySequence() {
        return this.useKeySequence;
    }

    @Override
    public final String toString() {
        return "BOSH connection configuration: " + (this.getChannelEncryption() == ChannelEncryption.DIRECT ? "https" : "http") + "://" + super.toString() + this.path;
    }

    public static final class Builder
    extends ClientConnectionConfiguration.Builder<Builder, BoshConnectionConfiguration> {
        private Duration wait;
        private String path;
        private String route;
        private boolean useKeySequence;

        private Builder() {
            this.channelEncryption(ChannelEncryption.DISABLED);
            this.wait(Duration.ofMinutes(1L));
            this.path("/http-bind/");
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder wait(Duration wait) {
            this.wait = wait;
            return this;
        }

        public Builder route(String route) {
            this.route = route;
            return this;
        }

        public Builder useKeySequence(boolean useKeySequence) {
            this.useKeySequence = useKeySequence;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoshConnectionConfiguration build() {
            if (this.proxy != null && this.proxy.type() != Proxy.Type.HTTP && this.proxy.type() != Proxy.Type.DIRECT) {
                throw new UnsupportedOperationException("Non-HTTP proxies are not supported by BOSH connections.");
            }
            if (this.channelEncryption != ChannelEncryption.DISABLED && this.channelEncryption != ChannelEncryption.DIRECT) {
                throw new IllegalArgumentException("BOSH connections only support ChannelEncryption.DIRECT (https) orChannelEncryption.DISABLED (http).");
            }
            return new BoshConnectionConfiguration(this);
        }
    }
}

