/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.sm.client;

import java.io.Writer;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.extensions.sm.AbstractStreamManager;
import rocks.xmpp.extensions.sm.model.StreamManagement;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ClientStreamManager
extends AbstractStreamManager
implements WriterInterceptor {
    private static final System.Logger logger = System.getLogger(ClientStreamManager.class.getName());
    private final XmppSession xmppSession;
    private StreamManagement.Enabled enabled;
    private CompletableFuture<Boolean> resumeFuture;

    private ClientStreamManager(XmppSession xmppSession) {
        super((Session)xmppSession);
        this.xmppSession = xmppSession;
        xmppSession.addSessionStatusListener(sessionStatusEvent -> {
            if (sessionStatusEvent.getStatus() == XmppSession.Status.CLOSING && this.isActive()) {
                StreamManagement.Answer answer;
                ClientStreamManager clientStreamManager = this;
                synchronized (clientStreamManager) {
                    answer = new StreamManagement.Answer(this.inboundCount);
                }
                xmppSession.send((StreamElement)answer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        if (!this.isEnabled()) {
            return StreamNegotiationResult.IGNORE;
        }
        StreamNegotiationResult result = super.processNegotiation(element);
        if (result != StreamNegotiationResult.IGNORE) {
            return result;
        }
        try {
            if (element instanceof StreamManagement) {
                if (this.enabledByClient.compareAndSet(false, true)) {
                    ClientStreamManager clientStreamManager = this;
                    synchronized (clientStreamManager) {
                        this.acknowledgedStanzaCount = 0L;
                    }
                    this.unacknowledgedStanzas.clear();
                    this.xmppSession.send((StreamElement)new StreamManagement.Enable(Boolean.valueOf(true)));
                    return StreamNegotiationResult.INCOMPLETE;
                }
                return StreamNegotiationResult.IGNORE;
            }
            if (element instanceof StreamManagement.Enabled) {
                ClientStreamManager clientStreamManager = this;
                synchronized (clientStreamManager) {
                    this.inboundCount = 0L;
                    this.enabled = (StreamManagement.Enabled)element;
                }
                return StreamNegotiationResult.SUCCESS;
            }
            if (element instanceof StreamManagement.Failed) {
                StreamManagement.Failed failed = (StreamManagement.Failed)element;
                if (failed.getLastHandledStanza() != null) {
                    this.markAcknowledged(failed.getLastHandledStanza());
                }
                ClientStreamManager clientStreamManager = this;
                synchronized (clientStreamManager) {
                    this.enabled = null;
                }
                this.resumed(false);
                if (failed.getError() == Condition.ITEM_NOT_FOUND) {
                    logger.log(System.Logger.Level.WARNING, "Could not find previous stream management session, stream resumption failed.");
                }
                return StreamNegotiationResult.IGNORE;
            }
            if (element instanceof StreamManagement.Resumed) {
                StreamManagement.Resumed resumed = (StreamManagement.Resumed)element;
                this.markAcknowledged(resumed.getLastHandledStanza());
                this.resumed(true);
                return StreamNegotiationResult.SUCCESS;
            }
        }
        catch (StreamErrorException e) {
            this.xmppSession.send((StreamElement)e.getError());
            try {
                this.xmppSession.close();
            }
            catch (XmppException e1) {
                this.xmppSession.notifyException(e1);
            }
            return StreamNegotiationResult.IGNORE;
        }
        return StreamNegotiationResult.IGNORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumed(boolean resumed) {
        CompletableFuture<Boolean> completableFuture;
        ClientStreamManager clientStreamManager = this;
        synchronized (clientStreamManager) {
            completableFuture = this.resumeFuture;
        }
        if (completableFuture != null) {
            completableFuture.complete(resumed);
        }
    }

    protected final void onAcknowledged(Stanza stanza) {
        this.xmppSession.markAcknowledged(stanza);
    }

    public final synchronized boolean isActive() {
        return this.enabled != null;
    }

    public final synchronized boolean isResumable() {
        return this.enabled != null && this.enabled.isResume();
    }

    public final synchronized String getStreamManagementId() {
        return this.enabled != null ? this.enabled.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult<Boolean> resume() {
        StreamManagement.Resume resume;
        if (!this.isResumable()) {
            return new AsyncResult(CompletableFuture.completedFuture(false));
        }
        CompletableFuture future = new CompletableFuture();
        ClientStreamManager clientStreamManager = this;
        synchronized (clientStreamManager) {
            this.resumeFuture = future;
            resume = new StreamManagement.Resume(this.inboundCount, this.getStreamManagementId());
        }
        this.xmppSession.send((StreamElement)resume);
        return new AsyncResult(future);
    }

    public void process(StreamElement streamElement, Writer writer, WriterInterceptorChain chain) throws Exception {
        if (streamElement instanceof Stanza) {
            this.markUnacknowledged((Stanza)streamElement);
            boolean requestStanzaCount = this.getRequestStrategy().test((Stanza)streamElement);
            if (this.isActive() && requestStanzaCount && this.xmppSession.getStatus() != XmppSession.Status.CLOSED) {
                this.xmppSession.send((StreamElement)StreamManagement.REQUEST);
            }
        }
        chain.proceed(streamElement, writer);
    }
}

