/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.chat;

import java.util.Collection;
import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.SendTask;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.im.chat.Chat;
import rocks.xmpp.im.chat.ChatManager;
import rocks.xmpp.util.XmppUtils;

public final class ChatSession
extends Chat
implements AutoCloseable {
    private final Set<Consumer<ChatPartnerEvent>> chatPartnerListeners = new CopyOnWriteArraySet<Consumer<ChatPartnerEvent>>();
    private final String thread;
    private final XmppSession xmppSession;
    private volatile Jid chatPartner;
    private final ChatManager chatManager;

    ChatSession(Jid chatPartner, String thread, XmppSession xmppSession, ChatManager chatManager) {
        this.chatPartner = Objects.requireNonNull(chatPartner, "chatPartner must not be null.");
        this.thread = thread;
        this.xmppSession = xmppSession;
        this.chatManager = chatManager;
    }

    public final void addChatPartnerListener(Consumer<ChatPartnerEvent> chatPartnerListener) {
        this.chatPartnerListeners.add(Objects.requireNonNull(chatPartnerListener, "chatPartnerListener must not be null"));
    }

    public final void removeChatPartnerListener(Consumer<ChatPartnerEvent> chatPartnerListener) {
        this.chatPartnerListeners.remove(Objects.requireNonNull(chatPartnerListener, "chatPartnerListener must not be nulll"));
    }

    @Override
    public SendTask<Message> sendMessage(String message) {
        return this.sendMessage(new Message(this.chatPartner, Message.Type.CHAT, message));
    }

    @Override
    public SendTask<Message> sendMessage(Message message) {
        Message m = new Message(this.chatPartner, Message.Type.CHAT, (Collection)message.getBodies(), (Collection)message.getSubjects(), this.thread, message.getParentThread(), message.getId(), message.getFrom(), message.getLanguage(), (Collection)message.getExtensions(), message.getError());
        return this.xmppSession.sendMessage(m);
    }

    public Jid getChatPartner() {
        return this.chatPartner;
    }

    final void setChatPartner(Jid chatPartner) {
        Jid oldChatPartner = this.chatPartner;
        this.chatPartner = chatPartner;
        if (!Objects.equals(oldChatPartner, chatPartner)) {
            XmppUtils.notifyEventListeners(this.chatPartnerListeners, (EventObject)new ChatPartnerEvent(this, Objects.requireNonNull(oldChatPartner, "oldChatPartner must not be null"), Objects.requireNonNull(chatPartner, "newChatPartner must not be null")));
        }
    }

    public final String getThread() {
        return this.thread;
    }

    @Override
    public final void close() {
        this.chatManager.destroyChatSession(this);
    }

    public static final class ChatPartnerEvent
    extends EventObject {
        private final Jid oldChatPartner;
        private final Jid newChatPartner;

        private ChatPartnerEvent(ChatSession source, Jid oldChatPartner, Jid newChatPartner) {
            super(Objects.requireNonNull(source, "source must not be null"));
            this.oldChatPartner = Objects.requireNonNull(oldChatPartner, "oldChatPartner must not be null");
            this.newChatPartner = Objects.requireNonNull(newChatPartner, "newChatPartner must not be null");
        }

        public final Jid getNewChatPartner() {
            return this.newChatPartner;
        }

        public final Jid getOldChatPartner() {
            return this.oldChatPartner;
        }
    }
}

