/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlTransient;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;

@XmlTransient
public abstract class ExtensibleStanza
extends Stanza {
    ExtensibleStanza(Jid to, Jid from, String id, Locale language, Collection<?> extensions, StanzaError error) {
        super(to, from, id, language, extensions, error);
    }

    public final boolean addExtension(Object extension) {
        return extension != null && this.getExtensions().add(extension);
    }

    public final void addExtensions(Object ... extensions) {
        this.addExtensions(Arrays.asList(extensions));
    }

    public final void addExtensions(Collection<Object> extensions) {
        if (extensions != null) {
            extensions.forEach(this::addExtension);
        }
    }

    public final boolean removeExtension(Class<?> clazz) {
        return this.getExtensions().removeIf(extension -> clazz != null && clazz.isAssignableFrom(extension.getClass()));
    }

    public final void putExtension(Object extension) {
        if (extension != null) {
            this.removeExtension(extension.getClass());
        }
        this.addExtension(extension);
    }

    public final List<Object> getExtensions() {
        return this.extensions;
    }

    public final <T> List<T> getExtensions(Class<T> clazz) {
        return Collections.unmodifiableList(this.extensions.stream().filter(extension -> clazz.isAssignableFrom(extension.getClass())).map(extension -> extension).collect(Collectors.toList()));
    }
}

