/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.Text;
import rocks.xmpp.core.stanza.model.ExtensibleStanza;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;

@XmlTransient
public class Presence
extends ExtensibleStanza
implements Comparable<Presence> {
    private static final Set<Type> SUBSCRIPTION_TYPES = EnumSet.of(Type.SUBSCRIBE, Type.SUBSCRIBED, Type.UNSUBSCRIBE, Type.UNSUBSCRIBED);
    private static final Comparator<Presence> DEFAULT_COMPARATOR = Comparator.nullsLast(Comparator.comparing(Presence::getPriority, (p1, p2) -> Byte.compare(p2 == null ? (byte)0 : p2, p1 == null ? (byte)0 : p1)).thenComparing(Presence::getType, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Presence::getShow, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Presence::getStatuses, Comparator.nullsFirst((o1, o2) -> {
        int diff = o1.size() - o2.size();
        if (diff == 0) {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            for (Text text1 : o1) {
                for (Text text2 : o2) {
                    int result = Comparator.nullsFirst(Text::compareTo).compare(text1, text2);
                    if (result == 0) continue;
                    return result;
                }
            }
        }
        return diff;
    })).thenComparing(Stanza::getFrom, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Stanza::getTo, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Stanza::getId, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Stanza::getError, Comparator.nullsFirst((o1, o2) -> {
        if (Objects.equals(o1, o2)) {
            return 0;
        }
        return -1;
    })).thenComparing(Stanza::getLanguage, Comparator.nullsFirst(Comparator.comparing(Locale::toLanguageTag))).thenComparing(ExtensibleStanza::getExtensions, Comparator.nullsFirst((o1, o2) -> {
        int diff = o1.size() - o2.size();
        if (diff == 0) {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            for (Object ext1 : o1) {
                for (Object ext2 : o2) {
                    if (Objects.equals(ext1, ext2)) continue;
                    return -1;
                }
            }
        }
        return diff;
    })));
    private final List<Text> status = new CopyOnWriteArrayList<Text>();
    private Byte priority;
    private Show show;
    @XmlAttribute
    private Type type;

    public Presence() {
        super(null, null, null, null, null, null);
        this.priority = null;
        this.show = null;
        this.type = null;
    }

    public Presence(byte priority) {
        this(null, null, null, null, priority, null, null, null, null, null);
    }

    public Presence(Show show) {
        this(show, 0);
    }

    public Presence(Show show, byte priority) {
        this(null, null, show, null, priority, null, null, null, null, null);
    }

    public Presence(Type type) {
        this(type, 0);
    }

    public Presence(Type type, byte priority) {
        this(null, type, null, null, priority, null, null, null, null, null);
    }

    public Presence(Jid to) {
        this(to, null, null, null);
    }

    public Presence(Jid to, Show show, String status) {
        this(to, null, show, status != null ? Collections.singleton(new Text(status)) : null, 0, null, null, null, null, null);
    }

    public Presence(Jid to, Type type, String status) {
        this(to, type, status, null);
    }

    public Presence(Jid to, Type type, String status, String id) {
        this(to, type, null, status != null ? Collections.singleton(new Text(status)) : null, 0, id, null, null, null, null);
    }

    public Presence(Jid to, Type type, Show show, Collection<Text> status, byte priority, String id, Jid from, Locale language, Collection<?> extensions, StanzaError error) {
        super(to, from, id, language, extensions, error);
        this.show = show;
        this.type = type;
        if (status != null) {
            this.status.addAll(status);
        }
        this.priority = priority == 0 ? null : Byte.valueOf(priority);
    }

    public final synchronized boolean isAvailable() {
        return this.type == null;
    }

    public final synchronized Show getShow() {
        return this.show;
    }

    public final synchronized void setShow(Show show) {
        this.show = show;
    }

    public final synchronized byte getPriority() {
        return this.priority != null ? this.priority : (byte)0;
    }

    public final synchronized void setPriority(byte priority) {
        this.priority = priority;
    }

    public final synchronized Type getType() {
        return this.type;
    }

    public final synchronized void setType(Type type) {
        this.type = type;
    }

    public final List<Text> getStatuses() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getStatus() {
        for (Text status : this.status) {
            if (status == null || status.getLanguage() != null) continue;
            return status.getText();
        }
        Presence presence = this;
        synchronized (presence) {
            if (!this.status.isEmpty()) {
                return this.status.get(0) != null ? this.status.get(0).getText() : null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setStatus(String text) {
        if (text != null) {
            Presence presence = this;
            synchronized (presence) {
                for (Text s : this.status) {
                    if (s.getLanguage() != null) continue;
                    this.status.remove(s);
                    break;
                }
                this.status.add(0, new Text(text));
            }
        } else {
            this.status.clear();
        }
    }

    public final boolean isSubscription() {
        return SUBSCRIPTION_TYPES.contains((Object)this.getType());
    }

    @Override
    public final Presence createError(StanzaError error) {
        return new Presence(this.getFrom(), Type.ERROR, this.getShow(), this.getStatuses(), this.getPriority(), this.getId(), this.getTo(), this.getLanguage(), this.getExtensions(), error);
    }

    @Override
    public final Presence createError(Condition condition) {
        return this.createError(new StanzaError(condition));
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Presence)) {
            return false;
        }
        Presence other = (Presence)o;
        return Objects.equals((Object)this.getType(), (Object)other.getType()) && this.getPriority() == other.getPriority() && Objects.equals((Object)this.getShow(), (Object)other.getShow()) && Objects.equals(this.getTo(), other.getTo()) && Objects.equals(this.getFrom(), other.getFrom()) && Objects.equals(this.getStatuses(), other.getStatuses()) && Objects.equals(this.getError(), other.getError()) && Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getLanguage(), other.getLanguage()) && Objects.equals(this.getExtensions(), other.getExtensions());
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getPriority(), this.getShow(), this.getTo(), this.getFrom(), this.getStatuses(), this.getError(), this.getId(), this.getLanguage(), this.getExtensions()});
    }

    @Override
    public final synchronized int compareTo(Presence o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    @Override
    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            String sType = this.type.name();
            sb.append(sType, 0, 1).append(sType.substring(1).toLowerCase()).append(' ');
        }
        sb.append("Presence");
        if (this.show != null) {
            sb.append(' ').append(this.show.name());
        }
        sb.append(super.toString());
        String status = this.getStatus();
        if (status != null) {
            sb.append(": ").append(status);
        }
        return sb.toString();
    }

    @XmlType(name="presenceType")
    public static enum Type {
        ERROR,
        PROBE,
        SUBSCRIBE,
        SUBSCRIBED,
        UNAVAILABLE,
        UNSUBSCRIBE,
        UNSUBSCRIBED;

    }

    public static enum Show {
        CHAT,
        AWAY,
        XA,
        DND;

    }
}

