/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.stanza.InboundPresenceHandler;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoProvider;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.extensions.hashes.model.Hashed;
import rocks.xmpp.util.cache.LruCache;

public abstract class AbstractEntityCapabilitiesProtocol<T extends EntityCapabilities>
implements InboundPresenceHandler,
InfoProvider,
ExtensionProtocol,
DiscoverableInfo {
    private static final System.Logger logger = System.getLogger(AbstractEntityCapabilitiesProtocol.class.getName());
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Map<Collection<InfoDiscovery>, EntityCapabilities> publishedNodes;
    private final Class<T> entityCapabilitiesClass;
    private final EntityCapabilitiesManager entityCapabilitiesManager;

    protected AbstractEntityCapabilitiesProtocol(Class<T> entityCapabilitiesClass, ServiceDiscoveryManager serviceDiscoveryManager, EntityCapabilitiesManager entityCapabilitiesManager) {
        this.serviceDiscoveryManager = Objects.requireNonNull(serviceDiscoveryManager);
        this.entityCapabilitiesClass = Objects.requireNonNull(entityCapabilitiesClass);
        this.entityCapabilitiesManager = Objects.requireNonNull(entityCapabilitiesManager);
        this.publishedNodes = new LruCache(10);
    }

    public final Class<T> getEntityCapabilitiesClass() {
        return this.entityCapabilitiesClass;
    }

    public final Map<Collection<InfoDiscovery>, EntityCapabilities> getPublishedNodes() {
        return Collections.unmodifiableMap(this.publishedNodes);
    }

    public final InfoDiscovery publishCapsNode() {
        InfoDiscovery infoDiscovery = new InfoDiscovery(this.serviceDiscoveryManager.getDefaultInfo().getIdentities(), this.serviceDiscoveryManager.getDefaultInfo().getFeatures(), this.serviceDiscoveryManager.getDefaultInfo().getExtensions());
        T entityCapabilities = this.produceEntityCapabilities(infoDiscovery);
        ArrayList<InfoDiscovery> infoDiscoveries = new ArrayList<InfoDiscovery>();
        Set<Hashed> capabilityHashSet = entityCapabilities.getCapabilityHashSet();
        for (Hashed hashed : capabilityHashSet) {
            this.entityCapabilitiesManager.writeCapabilities(Hash.from(hashed), infoDiscovery);
            String node = entityCapabilities.createCapabilityHashNode(hashed);
            infoDiscoveries.add(new InfoDiscovery(node, infoDiscovery.getIdentities(), infoDiscovery.getFeatures(), infoDiscovery.getExtensions()));
        }
        this.publishedNodes.put((Collection<InfoDiscovery>)infoDiscoveries, (EntityCapabilities)entityCapabilities);
        return infoDiscovery;
    }

    public void handleEntityCapabilities(EntityCapabilities entityCapabilities, Jid entity) {
        this.processCapabilitiesHashSet(entityCapabilities.getCapabilityHashSet().iterator(), entity, entityCapabilities);
    }

    private void processCapabilitiesHashSet(Iterator<Hashed> capabilityHashSet, Jid entity, EntityCapabilities caps) {
        if (capabilityHashSet.hasNext()) {
            Hashed hashed = capabilityHashSet.next();
            if (hashed.getHashAlgorithm() == null) {
                return;
            }
            Hash hash = Hash.from(hashed);
            DiscoverableInfo discoverableInfo = this.entityCapabilitiesManager.readCapabilities(hash);
            if (discoverableInfo != null) {
                this.entityCapabilitiesManager.writeEntityCapabilities(entity, discoverableInfo);
            } else {
                String nodeToDiscover = caps.createCapabilityHashNode(hash);
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(hash.getHashAlgorithm());
                    logger.log(System.Logger.Level.DEBUG, "Discovering capabilities for ''{0}'' at node {1}", entity, nodeToDiscover);
                    this.serviceDiscoveryManager.discoverInformation(entity, nodeToDiscover).whenComplete((infoDiscovery, e1) -> {
                        if (e1 != null) {
                            this.processCapabilitiesHashSet(capabilityHashSet, entity, caps);
                            logger.log(System.Logger.Level.WARNING, () -> "Failed to discover information for entity '" + entity + "' for node '" + nodeToDiscover + "'", (Throwable)e1);
                        } else {
                            ArrayDeque<String> ftValues = new ArrayDeque<String>();
                            for (DataForm dataForm : infoDiscovery.getExtensions()) {
                                DataForm.Field formType = dataForm.findField("FORM_TYPE");
                                if (formType == null || formType.getType() != DataForm.Field.Type.HIDDEN || formType.getValues().isEmpty()) continue;
                                ArrayDeque<String> values = new ArrayDeque<String>();
                                for (String value : formType.getValues()) {
                                    if (values.contains(value)) {
                                        return;
                                    }
                                    values.add(value);
                                }
                                String value = formType.getValues().get(0);
                                if (ftValues.contains(value)) {
                                    return;
                                }
                                ftValues.add(value);
                            }
                            byte[] verificationString = caps.createVerificationString((DiscoverableInfo)infoDiscovery);
                            byte[] computedHash = messageDigest.digest(verificationString);
                            if (Arrays.equals(computedHash, hash.getHashValue())) {
                                this.entityCapabilitiesManager.writeCapabilities(hash, (DiscoverableInfo)infoDiscovery);
                            } else {
                                this.processCapabilitiesHashSet(capabilityHashSet, entity, caps);
                            }
                            this.entityCapabilitiesManager.writeEntityCapabilities(entity, (DiscoverableInfo)infoDiscovery);
                        }
                    });
                }
                catch (NoSuchAlgorithmException e12) {
                    this.serviceDiscoveryManager.discoverInformation(entity, nodeToDiscover).whenComplete((result, e2) -> {
                        if (e2 != null) {
                            logger.log(System.Logger.Level.WARNING, "Failed to discover information for entity '{0}' for node '{1}'", entity, nodeToDiscover);
                        } else {
                            this.entityCapabilitiesManager.writeEntityCapabilities(entity, (DiscoverableInfo)result);
                        }
                    });
                    this.processCapabilitiesHashSet(capabilityHashSet, entity, caps);
                }
            }
        }
    }

    @Override
    public final void handleInboundPresence(PresenceEvent e) {
        EntityCapabilities caps;
        Presence presence = e.getPresence();
        if (!presence.getFrom().equals(((Session)e.getSource()).getLocalXmppAddress()) && (caps = (EntityCapabilities)presence.getExtension(this.entityCapabilitiesClass)) != null) {
            logger.log(System.Logger.Level.DEBUG, "Processing {0}", caps);
            this.handleEntityCapabilities(caps, presence.getFrom());
        }
    }

    @Override
    public final DiscoverableInfo getInfo(Jid to, Jid from, String node, Locale locale) {
        return this.publishedNodes.keySet().stream().flatMap(Collection::stream).filter(infoNode -> Objects.equals(infoNode.getNode(), node)).findFirst().orElse(null);
    }

    protected abstract T produceEntityCapabilities(DiscoverableInfo var1);
}

