/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.validate.model;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="validate")
public final class Validation {
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-validate";
    @XmlAttribute(name="datatype")
    private final String dataType;
    @XmlElements(value={@XmlElement(name="basic", type=ValidationMethod.Basic.class), @XmlElement(name="open", type=ValidationMethod.Open.class), @XmlElement(name="range", type=ValidationMethod.Range.class), @XmlElement(name="regex", type=ValidationMethod.Regex.class)})
    private final ValidationMethod validationMethod;
    @XmlElement(name="list-range")
    private final ListRange listRange;

    private Validation() {
        this(null, null, null);
    }

    public Validation(String dataType) {
        this(dataType, null);
    }

    public Validation(ValidationMethod validationMethod) {
        this(null, validationMethod);
    }

    public Validation(String dataType, ValidationMethod validationMethod) {
        this(dataType, validationMethod, null);
    }

    public Validation(String dataType, ValidationMethod validationMethod, ListRange listRange) {
        this.dataType = dataType;
        this.validationMethod = validationMethod;
        this.listRange = listRange;
    }

    public final ValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public final String getDataType() {
        return this.dataType;
    }

    public final ListRange getListRange() {
        return this.listRange;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validation)) {
            return false;
        }
        Validation other = (Validation)o;
        return Objects.equals(this.dataType, other.dataType) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.listRange, other.listRange);
    }

    public final int hashCode() {
        return Objects.hash(this.dataType, this.validationMethod, this.listRange);
    }

    public static final class ListRange {
        @XmlAttribute
        private final Integer min;
        @XmlAttribute
        private final Integer max;

        private ListRange() {
            this.min = null;
            this.max = null;
        }

        public ListRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public final Integer getMin() {
            return this.min;
        }

        public final Integer getMax() {
            return this.max;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListRange)) {
                return false;
            }
            ListRange other = (ListRange)o;
            return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }

        public final int hashCode() {
            return Objects.hash(this.min, this.max);
        }
    }

    @XmlTransient
    public static abstract class ValidationMethod {
        @XmlValue
        final String value;

        private ValidationMethod() {
            this.value = null;
        }

        private ValidationMethod(String value) {
            this.value = value;
        }

        public static final class Regex
        extends ValidationMethod {
            private Regex() {
                super(null);
            }

            public Regex(String regex) {
                super(regex);
            }

            public final String getRegex() {
                return this.value;
            }

            public final boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Regex)) {
                    return false;
                }
                Regex other = (Regex)o;
                return Objects.equals(this.value, other.value);
            }

            public final int hashCode() {
                return Objects.hash(this.value);
            }
        }

        public static final class Range
        extends ValidationMethod {
            @XmlAttribute
            private final String min;
            @XmlAttribute
            private final String max;

            private Range() {
                this.min = null;
                this.max = null;
            }

            public Range(String min, String max) {
                this.min = min;
                this.max = max;
            }

            public final String getMin() {
                return this.min;
            }

            public final String getMax() {
                return this.max;
            }

            public final boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Range)) {
                    return false;
                }
                Range other = (Range)o;
                return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
            }

            public final int hashCode() {
                return Objects.hash(this.min, this.max);
            }
        }

        public static final class Open
        extends ValidationMethod {
            public final boolean equals(Object o) {
                return o == this || o instanceof Open;
            }

            public final int hashCode() {
                return Open.class.hashCode();
            }
        }

        public static final class Basic
        extends ValidationMethod {
            public final boolean equals(Object o) {
                return o == this || o instanceof Basic;
            }

            public final int hashCode() {
                return Basic.class.hashCode();
            }
        }
    }
}

