/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.disco.DiscoInfoHandler;
import rocks.xmpp.extensions.disco.DiscoItemsHandler;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.ServiceDiscoveryNode;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoProvider;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.disco.model.items.ItemProvider;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;
import rocks.xmpp.util.concurrent.AsyncResult;
import rocks.xmpp.util.concurrent.CompletionStages;

public abstract class AbstractServiceDiscoveryManager
implements ServiceDiscoveryManager {
    private static final Set<String> FEATURES;
    private final DiscoInfoHandler discoInfoHandler = new DiscoInfoHandler();
    private final DiscoItemsHandler discoItemHandler = new DiscoItemsHandler();

    protected AbstractServiceDiscoveryManager() {
    }

    @Override
    public final String getNamespace() {
        return "http://jabber.org/protocol/disco#info";
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }

    @Override
    public final Set<String> getFeatures() {
        return FEATURES;
    }

    @Override
    public final Class<?> getPayloadClass() {
        return ServiceDiscoveryNode.class;
    }

    @Override
    public final IQ handleRequest(IQ iq) {
        if (iq.hasExtension(InfoDiscovery.class)) {
            return this.discoInfoHandler.handleRequest(iq);
        }
        if (iq.hasExtension(ItemNode.class)) {
            return this.discoItemHandler.handleRequest(iq);
        }
        return iq.createError(Condition.SERVICE_UNAVAILABLE);
    }

    @Override
    public final AsyncResult<DiscoverableInfo> discoverInformation(Jid jid) {
        return this.discoverInformation(jid, null);
    }

    @Override
    public final AsyncResult<ItemNode> discoverItems(Jid jid) {
        return this.discoverItems(jid, null, null);
    }

    @Override
    public final AsyncResult<ItemNode> discoverItems(Jid jid, ResultSetManagement resultSet) {
        return this.discoverItems(jid, null, resultSet);
    }

    @Override
    public final AsyncResult<ItemNode> discoverItems(Jid jid, String node) {
        return this.discoverItems(jid, node, null);
    }

    @Override
    public final boolean addInfoProvider(InfoProvider infoProvider) {
        return this.discoInfoHandler.addInfoProvider(infoProvider);
    }

    @Override
    public final boolean removeInfoProvider(InfoProvider infoNodeProvider) {
        return this.discoInfoHandler.removeInfoProvider(infoNodeProvider);
    }

    @Override
    public final boolean addItemProvider(ItemProvider itemProvider) {
        return this.discoItemHandler.addItemProvider(itemProvider);
    }

    @Override
    public final boolean removeItemProvider(ItemProvider itemProvider) {
        return this.discoItemHandler.removeItemProvider(itemProvider);
    }

    @Override
    public final AsyncResult<List<Item>> discoverServices(Jid jid, Identity identity) {
        return this.discoverServices(jid, (DiscoverableInfo infoNode) -> {
            for (Identity id : infoNode.getIdentities()) {
                if (!id.getCategory().equals(identity.getCategory()) || !id.getType().equals(identity.getType())) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public final AsyncResult<List<Item>> discoverServices(Jid jid, String feature) {
        return this.discoverServices(jid, (DiscoverableInfo infoNode) -> infoNode.getFeatures().contains(feature));
    }

    private AsyncResult<List<Item>> discoverServices(Jid jid, Predicate<DiscoverableInfo> predicate) {
        return this.discoverItems(jid).thenCompose(itemDiscovery -> {
            Collection stages = itemDiscovery.getItems().stream().map(item -> ((AsyncResult)this.discoverInformation(item.getJid()).thenApply(infoDiscovery -> {
                if (predicate.test((DiscoverableInfo)infoDiscovery)) {
                    return Collections.singletonList(item);
                }
                return Collections.emptyList();
            })).handle((items, throwable) -> {
                if (throwable != null) {
                    return Collections.emptyList();
                }
                return items;
            })).collect(Collectors.toList());
            return CompletionStages.allOf(stages);
        });
    }

    static {
        HashSet<String> features = new HashSet<String>();
        features.add("http://jabber.org/protocol/disco#items");
        features.add("http://jabber.org/protocol/disco#info");
        FEATURES = Collections.unmodifiableSet(features);
    }
}

