/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoProvider;

final class DiscoInfoHandler
extends AbstractIQHandler {
    private final Set<InfoProvider> infoProviders = new CopyOnWriteArraySet<InfoProvider>();

    DiscoInfoHandler() {
        super(InfoDiscovery.class, IQ.Type.GET);
    }

    @Override
    protected final IQ processRequest(IQ iq) {
        InfoDiscovery infoDiscovery = iq.getExtension(InfoDiscovery.class);
        HashSet<DiscoverableInfo> discoverableInfos = new HashSet<DiscoverableInfo>();
        for (InfoProvider infoNodeProvider : this.infoProviders) {
            try {
                DiscoverableInfo info = infoNodeProvider.getInfo(iq.getTo(), iq.getFrom(), infoDiscovery.getNode(), iq.getLanguage());
                if (info == null) continue;
                discoverableInfos.add(info);
            }
            catch (StanzaErrorException e) {
                return iq.createError(e.getError());
            }
        }
        Set<String> features = discoverableInfos.stream().filter(infoNode1 -> Objects.nonNull(infoNode1.getFeatures())).flatMap(infoNode1 -> infoNode1.getFeatures().stream()).collect(Collectors.toSet());
        Set<Identity> identities = discoverableInfos.stream().filter(infoNode1 -> Objects.nonNull(infoNode1.getIdentities())).flatMap(infoNode1 -> infoNode1.getIdentities().stream()).collect(Collectors.toSet());
        List<DataForm> extensions = discoverableInfos.stream().filter(infoNode1 -> Objects.nonNull(infoNode1.getExtensions())).flatMap(infoNode1 -> infoNode1.getExtensions().stream()).collect(Collectors.toList());
        if (!discoverableInfos.isEmpty()) {
            return iq.createResult(new InfoDiscovery(infoDiscovery.getNode(), identities, features, extensions));
        }
        return iq.createError(Condition.ITEM_NOT_FOUND);
    }

    final boolean addInfoProvider(InfoProvider infoProvider) {
        return this.infoProviders.add(infoProvider);
    }

    final boolean removeInfoProvider(InfoProvider infoProvider) {
        return this.infoProviders.remove(infoProvider);
    }
}

