/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaErrorException;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.disco.model.items.DiscoverableItem;
import rocks.xmpp.extensions.disco.model.items.ItemDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemProvider;
import rocks.xmpp.extensions.rsm.ResultSet;
import rocks.xmpp.extensions.rsm.ResultSetProvider;

final class DiscoItemsHandler
extends AbstractIQHandler {
    private final Set<ItemProvider> itemProviders = new CopyOnWriteArraySet<ItemProvider>();

    DiscoItemsHandler() {
        super(ItemDiscovery.class, IQ.Type.GET);
    }

    @Override
    protected IQ processRequest(IQ iq) {
        ItemDiscovery itemDiscovery = iq.getExtension(ItemDiscovery.class);
        ArrayList providers = new ArrayList();
        for (ItemProvider itemProvider : this.itemProviders) {
            try {
                ResultSetProvider<DiscoverableItem> itemResultSetProvider = itemProvider.getItems(iq.getTo(), iq.getFrom(), itemDiscovery.getNode(), iq.getLanguage());
                if (itemResultSetProvider == null) continue;
                providers.add(itemResultSetProvider);
            }
            catch (StanzaErrorException e) {
                return iq.createError(e.getError());
            }
        }
        if (!providers.isEmpty()) {
            ResultSetProvider combinedResultSetProvider = ResultSetProvider.combine(providers);
            ResultSet resultSet = ResultSet.create(combinedResultSetProvider, itemDiscovery.getResultSetManagement());
            return iq.createResult(new ItemDiscovery(itemDiscovery.getNode(), resultSet.getItems(), resultSet.getResultSetManagement()));
        }
        return iq.createError(Condition.ITEM_NOT_FOUND);
    }

    final boolean addItemProvider(ItemProvider itemProvider) {
        return this.itemProviders.add(itemProvider);
    }

    final boolean removeItemProvider(ItemProvider itemProvider) {
        return this.itemProviders.remove(itemProvider);
    }
}

