/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco.model.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.LanguageElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.ServiceDiscoveryNode;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.FeatureElement;
import rocks.xmpp.extensions.disco.model.info.Identity;

@XmlRootElement(name="query")
public final class InfoDiscovery
implements DiscoverableInfo,
ServiceDiscoveryNode,
LanguageElement {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final Set<Identity> identity = new TreeSet<Identity>();
    private final Set<FeatureElement> feature = new TreeSet<FeatureElement>();
    @XmlElementRef
    private final List<DataForm> extensions = new ArrayList<DataForm>();
    @XmlAttribute
    private final String node;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;

    public InfoDiscovery() {
        this(null);
    }

    public InfoDiscovery(String node) {
        this.node = node;
        this.lang = null;
    }

    public InfoDiscovery(Collection<Identity> identities, Collection<String> features) {
        this(null, identities, features, null);
    }

    public InfoDiscovery(Collection<Identity> identities, Collection<String> features, Collection<DataForm> extensions) {
        this(null, identities, features, extensions);
    }

    public InfoDiscovery(String node, Collection<Identity> identities, Collection<String> features, Collection<DataForm> extensions) {
        this(node, identities, features, extensions, null);
    }

    public InfoDiscovery(String node, Collection<Identity> identities, Collection<String> features, Collection<DataForm> extensions, Locale lang) {
        this.node = node;
        if (identities != null) {
            this.identity.addAll(identities);
        }
        if (features != null) {
            this.feature.addAll(features.stream().map(FeatureElement::new).collect(Collectors.toList()));
        }
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
        this.lang = lang;
    }

    @Override
    public final Set<Identity> getIdentities() {
        return Collections.unmodifiableSet(this.identity);
    }

    @Override
    public final Set<String> getFeatures() {
        Set set = this.feature.stream().filter(f -> f.getFeatureName() != null).map(FeatureElement::getFeatureName).collect(Collectors.toCollection(TreeSet::new));
        return Collections.unmodifiableSet(set);
    }

    @Override
    public final String getNode() {
        return this.node;
    }

    @Override
    public final List<DataForm> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    @Override
    public final Locale getLanguage() {
        return this.lang;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfoDiscovery)) {
            return false;
        }
        InfoDiscovery other = (InfoDiscovery)o;
        return Objects.equals(this.getNode(), other.getNode()) && Objects.equals(this.getIdentities(), other.getIdentities()) && Objects.equals(this.getFeatures(), other.getFeatures()) && Objects.equals(this.getExtensions(), other.getExtensions());
    }

    public final int hashCode() {
        return Objects.hash(this.getNode(), this.getIdentities(), this.getFeatures(), this.getExtensions());
    }

    public final String toString() {
        return "Identity: " + this.identity + "; Features: " + this.feature;
    }
}

