/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.hashes.model;

import java.util.Arrays;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.extensions.hashes.model.HashUsed;
import rocks.xmpp.extensions.hashes.model.Hashed;

@XmlRootElement
@XmlSeeAlso(value={HashUsed.class})
public final class Hash
implements Hashed {
    public static final String NAMESPACE = "urn:xmpp:hashes:2";
    @XmlValue
    private final byte[] value;
    @XmlAttribute
    private final String algo;

    private Hash() {
        this.value = null;
        this.algo = null;
    }

    public Hash(byte[] value, String algorithm) {
        this.value = (byte[])Objects.requireNonNull(value).clone();
        this.algo = Objects.requireNonNull(algorithm);
    }

    public static Hash from(Hashed hashed) {
        if (hashed instanceof Hash) {
            return (Hash)hashed;
        }
        return new Hash(hashed.getHashValue(), hashed.getHashAlgorithm());
    }

    @Override
    public final String getHashAlgorithm() {
        return this.algo;
    }

    @Override
    public final byte[] getHashValue() {
        return (byte[])this.value.clone();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hash)) {
            return false;
        }
        Hash other = (Hash)o;
        return Objects.equals(this.algo, other.algo) && Arrays.equals(this.value, other.value);
    }

    public final int hashCode() {
        return Objects.hash(this.algo, Arrays.hashCode(this.value));
    }

    public final String toString() {
        return "Hash (" + this.algo + "): " + DatatypeConverter.printBase64Binary((byte[])this.value);
    }
}

