/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind.model;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.model.SessionOpen;

@XmlRootElement
public final class Body
implements SessionOpen,
Comparable<Body> {
    public static final String NAMESPACE = "http://jabber.org/protocol/httpbind";
    public static final String XBOSH_NAMESPACE = "urn:xmpp:xbosh";
    @XmlAnyElement(lax=true)
    private final List<Object> wrappedObjects = new ArrayList<Object>();
    private final URI uri;
    @XmlAttribute
    private final String accept;
    @XmlAttribute
    private final Long ack;
    @XmlAttribute(name="authid")
    private final String authId;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CharsetAdapter.class)
    private final List<Charset> charsets;
    @XmlAttribute
    private final Condition condition;
    @XmlAttribute
    private final String content;
    @XmlAttribute
    private final Jid from;
    @XmlAttribute
    private final Short hold;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration inactivity;
    @XmlAttribute
    private final String key;
    @XmlAttribute(name="maxpause")
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration maxPause;
    @XmlAttribute(name="newkey")
    private final String newKey;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration pause;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration polling;
    @XmlAttribute
    private final Long report;
    @XmlAttribute
    private final Short requests;
    @XmlAttribute
    private final Long rid;
    @XmlAttribute
    private final String route;
    @XmlAttribute
    private final String sid;
    @XmlAttribute
    private final String stream;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=MillisecondsAdapter.class)
    private final Duration time;
    @XmlAttribute
    private final Jid to;
    @XmlAttribute
    private final Type type;
    @XmlAttribute
    private final String ver;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=SecondsAdapter.class)
    private final Duration wait;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;
    @XmlAttribute(namespace="urn:xmpp:xbosh")
    private final String version;
    @XmlAttribute(namespace="urn:xmpp:xbosh")
    private final Boolean restartlogic;
    @XmlAttribute(namespace="urn:xmpp:xbosh")
    private final Boolean restart;

    private Body() {
        this.uri = null;
        this.accept = null;
        this.ack = null;
        this.authId = null;
        this.charsets = null;
        this.condition = null;
        this.content = null;
        this.from = null;
        this.hold = null;
        this.inactivity = null;
        this.key = null;
        this.maxPause = null;
        this.newKey = null;
        this.pause = null;
        this.polling = null;
        this.report = null;
        this.requests = null;
        this.rid = null;
        this.route = null;
        this.sid = null;
        this.stream = null;
        this.time = null;
        this.to = null;
        this.type = null;
        this.ver = null;
        this.wait = null;
        this.lang = null;
        this.restart = null;
        this.restartlogic = null;
        this.version = null;
    }

    private Body(Builder builder) {
        this.uri = builder.uri;
        this.accept = builder.accept;
        this.ack = builder.ack;
        this.authId = builder.authId;
        this.charsets = builder.charsets != null ? Arrays.asList(builder.charsets) : null;
        this.condition = builder.condition;
        this.content = builder.content;
        this.from = builder.from;
        this.hold = builder.hold;
        this.inactivity = builder.inactivity;
        this.key = builder.key;
        this.maxPause = builder.maxPause;
        this.newKey = builder.newKey;
        this.pause = builder.pause;
        this.polling = builder.polling;
        this.report = builder.report;
        this.requests = builder.requests;
        this.rid = builder.requestId;
        this.route = builder.route;
        this.sid = builder.sessionId;
        this.stream = builder.stream;
        this.time = builder.time;
        this.to = builder.to;
        this.type = builder.type;
        this.ver = builder.version;
        this.wait = builder.wait;
        this.lang = builder.language;
        this.restart = builder.restart;
        this.restartlogic = builder.restartlogic;
        this.version = builder.xmppVersion;
        this.wrappedObjects.addAll(builder.wrappedObjects);
    }

    public static Builder builder() {
        return new Builder();
    }

    public final List<Object> getWrappedObjects() {
        return Collections.unmodifiableList(this.wrappedObjects);
    }

    public final URI getUri() {
        return this.uri;
    }

    public final String getAccept() {
        return this.accept;
    }

    public final Long getAck() {
        return this.ack;
    }

    public final String getAuthId() {
        return this.authId;
    }

    public final List<Charset> getCharsets() {
        return this.charsets != null ? this.charsets : Collections.emptyList();
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public final String getContent() {
        return this.content;
    }

    @Override
    public final Jid getFrom() {
        return this.from;
    }

    public final Short getHold() {
        return this.hold;
    }

    public final Duration getInactivity() {
        return this.inactivity;
    }

    public final String getKey() {
        return this.key;
    }

    public final Duration getMaxPause() {
        return this.maxPause;
    }

    public final String getNewKey() {
        return this.newKey;
    }

    public final Duration getPause() {
        return this.pause;
    }

    public final Duration getPolling() {
        return this.polling;
    }

    public final Long getReport() {
        return this.report;
    }

    public final Short getRequests() {
        return this.requests;
    }

    public final Long getRid() {
        return this.rid;
    }

    public final String getRoute() {
        return this.route;
    }

    public final String getSid() {
        return this.sid;
    }

    @Override
    public final String getId() {
        return this.sid;
    }

    public final String getStream() {
        return this.stream;
    }

    public final Duration getTime() {
        return this.time;
    }

    @Override
    public final Jid getTo() {
        return this.to;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getBoshVersion() {
        return this.ver;
    }

    public final Duration getWait() {
        return this.wait;
    }

    @Override
    public final Locale getLanguage() {
        return this.lang;
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    public final boolean isRestart() {
        return this.restart != null && this.restart != false;
    }

    public final boolean isRestartLogic() {
        return this.restartlogic != null && this.restartlogic != false;
    }

    @Override
    public final int compareTo(Body o) {
        if (o == null) {
            return -1;
        }
        return Comparator.comparing(Body::getRid, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getSid, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getType, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getCondition, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getWrappedObjects, (o1, o2) -> o1.equals(o2) ? 0 : Integer.compare(o1.hashCode(), o2.hashCode())).thenComparing(Body::getFrom, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getTo, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getUri, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getAccept, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getAck, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getAuthId, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getCharsets, (o1, o2) -> o1.equals(o2) ? 0 : Integer.compare(o1.hashCode(), o2.hashCode())).thenComparing(Body::getContent, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getHold, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getInactivity, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getKey, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getMaxPause, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getNewKey, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getPause, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getPolling, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getReport, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getRequests, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getRoute, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getStream, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getTime, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getBoshVersion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getWait, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::getLanguage, Comparator.nullsFirst(Comparator.comparing(Locale::toLanguageTag))).thenComparing(Body::getVersion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::isRestartLogic, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Body::isRestart, Comparator.nullsFirst(Comparator.naturalOrder())).compare(this, o);
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Body)) {
            return false;
        }
        Body o = (Body)other;
        return Objects.equals(this.wrappedObjects, o.wrappedObjects) && Objects.equals(this.uri, o.uri) && Objects.equals(this.accept, o.accept) && Objects.equals(this.ack, o.ack) && Objects.equals(this.authId, o.authId) && Objects.equals(this.charsets, o.charsets) && Objects.equals((Object)this.condition, (Object)o.condition) && Objects.equals(this.content, o.content) && Objects.equals(this.from, o.from) && Objects.equals(this.hold, o.hold) && Objects.equals(this.inactivity, o.inactivity) && Objects.equals(this.key, o.key) && Objects.equals(this.maxPause, o.maxPause) && Objects.equals(this.newKey, o.newKey) && Objects.equals(this.pause, o.pause) && Objects.equals(this.polling, o.polling) && Objects.equals(this.report, o.report) && Objects.equals(this.requests, o.requests) && Objects.equals(this.rid, o.rid) && Objects.equals(this.route, o.route) && Objects.equals(this.sid, o.sid) && Objects.equals(this.stream, o.stream) && Objects.equals(this.time, o.time) && Objects.equals(this.to, o.to) && Objects.equals((Object)this.type, (Object)o.type) && Objects.equals(this.ver, o.ver) && Objects.equals(this.wait, o.wait) && Objects.equals(this.lang, o.lang) && Objects.equals(this.version, o.version) && Objects.equals(this.restartlogic, o.restartlogic) && Objects.equals(this.restart, o.restart);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.accept, this.ack, this.authId, this.charsets, this.condition, this.content, this.from, this.hold, this.inactivity, this.key, this.maxPause, this.newKey, this.pause, this.polling, this.report, this.requests, this.rid, this.route, this.sid, this.stream, this.time, this.to, this.type, this.ver, this.wait, this.lang, this.version, this.restartlogic, this.restart});
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.rid != null) {
            sb.append("RID: ").append(this.rid).append("; ");
        }
        if (this.sid != null) {
            sb.append("SID: ").append(this.sid).append("; ");
        }
        if (this.wait != null) {
            sb.append("Wait: ").append(this.wait);
        }
        return sb.toString();
    }

    private static final class MillisecondsAdapter
    extends XmlAdapter<Integer, Duration> {
        private MillisecondsAdapter() {
        }

        public final Duration unmarshal(Integer v) {
            if (v != null) {
                return Duration.ofMillis(v.intValue());
            }
            return null;
        }

        public final Integer marshal(Duration v) {
            if (v != null) {
                return (int)Math.min(v.toMillis(), Integer.MAX_VALUE);
            }
            return null;
        }
    }

    private static final class SecondsAdapter
    extends XmlAdapter<Integer, Duration> {
        private SecondsAdapter() {
        }

        public final Duration unmarshal(Integer v) {
            if (v != null) {
                return Duration.ofSeconds(v.intValue());
            }
            return null;
        }

        public final Integer marshal(Duration v) {
            if (v != null) {
                return (int)Math.min(v.getSeconds(), Integer.MAX_VALUE);
            }
            return null;
        }
    }

    private static final class CharsetAdapter
    extends XmlAdapter<String, List<Charset>> {
        private CharsetAdapter() {
        }

        public final List<Charset> unmarshal(String charsets) {
            if (charsets != null) {
                return Arrays.stream(charsets.split(" ")).map(Charset::forName).collect(Collectors.toUnmodifiableList());
            }
            return null;
        }

        public final String marshal(List<Charset> charsets) {
            if (charsets != null && !charsets.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner(" ");
                charsets.stream().map(c -> c.name()).forEachOrdered(stringJoiner::add);
                return stringJoiner.toString();
            }
            return null;
        }
    }

    public static final class Builder {
        private URI uri;
        private final List<Object> wrappedObjects = new ArrayList<Object>();
        private String accept;
        private Long ack;
        private String authId;
        private Charset[] charsets;
        private Condition condition;
        private String content;
        private Jid from;
        private Short hold;
        private Duration inactivity;
        private String key;
        private Duration maxPause;
        private String newKey;
        private Duration pause;
        private Duration polling;
        private Long report;
        private Short requests;
        private Long requestId;
        private String route;
        private String sessionId;
        private String stream;
        private Duration time;
        private Jid to;
        private Type type;
        private String version;
        private Duration wait;
        private Locale language;
        private String xmppVersion;
        private Boolean restart;
        private Boolean restartlogic;

        private Builder() {
        }

        public final Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final Builder ack(long ack) {
            this.ack = ack;
            return this;
        }

        public final Builder authId(String authId) {
            this.authId = authId;
            return this;
        }

        public final Builder charsets(Charset ... charsets) {
            this.charsets = charsets;
            return this;
        }

        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Builder from(Jid from) {
            this.from = from;
            return this;
        }

        public final Builder hold(short hold) {
            this.hold = hold;
            return this;
        }

        public final Builder inactivity(Duration inactivity) {
            this.inactivity = inactivity;
            return this;
        }

        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Builder maxPause(Duration maxPause) {
            this.maxPause = maxPause;
            return this;
        }

        public final Builder newKey(String newKey) {
            this.newKey = newKey;
            return this;
        }

        public final Builder pause(Duration pause) {
            this.pause = pause;
            return this;
        }

        public final Builder polling(Duration polling) {
            this.polling = polling;
            return this;
        }

        public final Builder report(long report) {
            this.report = report;
            return this;
        }

        public final Builder requests(short requests) {
            this.requests = requests;
            return this;
        }

        public final Builder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Builder route(String route) {
            this.route = route;
            return this;
        }

        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Builder stream(String stream) {
            this.stream = stream;
            return this;
        }

        public final Builder time(Duration time) {
            this.time = time;
            return this;
        }

        public final Builder to(Jid to) {
            this.to = to;
            return this;
        }

        public final Builder type(Type type) {
            this.type = type;
            return this;
        }

        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Builder wait(Duration wait) {
            this.wait = wait;
            return this;
        }

        public final Builder language(Locale language) {
            this.language = language;
            return this;
        }

        public final Builder xmppVersion(String xmppVersion) {
            this.xmppVersion = xmppVersion;
            return this;
        }

        public final Builder restart(boolean restart) {
            this.restart = restart;
            return this;
        }

        public final Builder restartLogic(boolean restartlogic) {
            this.restartlogic = restartlogic;
            return this;
        }

        public final Builder wrappedObjects(Collection<Object> objects) {
            this.wrappedObjects.clear();
            this.wrappedObjects.addAll(objects);
            return this;
        }

        public final Body build() {
            return new Body(this);
        }
    }

    @XmlEnum
    public static enum Type {
        ERROR,
        TERMINATE;

    }

    @XmlEnum
    public static enum Condition {
        BAD_REQUEST,
        HOST_GONE,
        HOST_UNKNOWN,
        IMPROPER_ADDRESSING,
        INTERNAL_SERVER_ERROR,
        ITEM_NOT_FOUND,
        OTHER_REQUEST,
        POLICY_VIOLATION,
        REMOTE_CONNECTION_FAILED,
        REMOTE_STREAM_ERROR,
        SEE_OTHER_URI,
        SYSTEM_SHUTDOWN,
        UNDEFINED_CONDITION;


        public String toString() {
            return this.name().toLowerCase().replace("_", "-");
        }
    }
}

