/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.sm;

import java.util.Collections;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.sm.RequestStrategies;
import rocks.xmpp.extensions.sm.model.StreamManagement;

public abstract class AbstractStreamManager
implements StreamFeatureNegotiator<StreamManagement>,
ExtensionProtocol,
DiscoverableInfo {
    private static final long MAX_H = 0xFFFFFFFFL;
    protected final Queue<Stanza> unacknowledgedStanzas = new ConcurrentLinkedDeque<Stanza>();
    protected final AtomicBoolean enabledByClient = new AtomicBoolean();
    private final Session session;
    protected long inboundCount = 0L;
    protected long acknowledgedStanzaCount = 0L;
    protected long outboundCount = 0L;
    private boolean enabled = true;
    private Predicate<Stanza> requestStrategy = RequestStrategies.forEachMessageOrEveryXStanzas(3);

    protected AbstractStreamManager(Session session) {
        this.session = session;
    }

    static long diff(long h, long acknowledgedCount) {
        return h - acknowledgedCount & 0xFFFFFFFFL;
    }

    @Override
    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final synchronized Predicate<Stanza> getRequestStrategy() {
        return this.requestStrategy;
    }

    public final synchronized void setRequestStrategy(Predicate<Stanza> requestStrategy) {
        this.requestStrategy = requestStrategy;
    }

    @Override
    public final String getNamespace() {
        return "urn:xmpp:sm:3";
    }

    @Override
    public final Set<String> getFeatures() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        block7: {
            try {
                if (element instanceof StreamManagement.Request) {
                    StreamManagement.Answer answer;
                    AbstractStreamManager abstractStreamManager = this;
                    synchronized (abstractStreamManager) {
                        answer = new StreamManagement.Answer(this.inboundCount);
                    }
                    this.session.send(answer);
                    break block7;
                }
                if (element instanceof StreamManagement.Answer) {
                    StreamManagement.Answer answer = (StreamManagement.Answer)element;
                    this.markAcknowledged(answer.getLastHandledStanza());
                }
            }
            catch (StreamErrorException e) {
                this.session.closeAsync(e.getError());
                throw new StreamNegotiationException(e);
            }
        }
        return StreamNegotiationResult.IGNORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAcknowledged(Long h) throws StreamErrorException {
        if (h != null) {
            long x;
            AbstractStreamManager abstractStreamManager = this;
            synchronized (abstractStreamManager) {
                x = AbstractStreamManager.diff(h, this.acknowledgedStanzaCount);
                this.acknowledgedStanzaCount = h;
                if (h > this.outboundCount) {
                    throw new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, "", Locale.ENGLISH, new StreamManagement.HandledCountTooHigh(h, this.outboundCount)));
                }
            }
            for (long i = 0L; i < x; ++i) {
                Stanza stanza = this.unacknowledgedStanzas.poll();
                if (stanza == null) continue;
                this.onAcknowledged(stanza);
            }
        }
    }

    protected void onAcknowledged(Stanza stanza) {
    }

    public synchronized void incrementInboundStanzaCount() {
        this.inboundCount = this.inboundCount + 1L & 0xFFFFFFFFL;
    }

    public synchronized void markUnacknowledged(Stanza stanza) {
        if (this.enabledByClient.get()) {
            this.unacknowledgedStanzas.offer(stanza);
            this.outboundCount = this.outboundCount + 1L & 0xFFFFFFFFL;
        }
    }
}

