/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;

public final class LanguageUnmarshallerListener
extends Unmarshaller.Listener {
    private final Locale rootLocale;
    private final IdentityHashMap<Object, List<Object>> parentToChildren = new IdentityHashMap();
    private final Deque<Object> stack = new ArrayDeque<Object>();

    public LanguageUnmarshallerListener(Locale rootLocale) {
        this.rootLocale = rootLocale;
    }

    public final void afterUnmarshal(Object target, Object parent) {
        super.afterUnmarshal(target, parent);
        Object root = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.assignLocale(root, this.rootLocale);
        }
    }

    public final void beforeUnmarshal(Object target, Object parent) {
        super.beforeUnmarshal(target, parent);
        if (!this.stack.isEmpty()) {
            List children = this.parentToChildren.computeIfAbsent(parent, key -> new ArrayList());
            children.add(target);
        }
        this.stack.push(target);
    }

    private void assignLocale(Object object, Locale parentLocale) {
        Locale locale = LanguageUnmarshallerListener.setLocaleIfNull(object, parentLocale);
        List<Object> children = this.parentToChildren.remove(object);
        if (children != null) {
            for (Object child : children) {
                this.assignLocale(child, locale);
            }
        }
    }

    private static Locale setLocaleIfNull(Object target, Locale parentLocale) {
        if (target == null) {
            return parentLocale;
        }
        Class<?> current = target.getClass();
        while (current.getSuperclass() != null) {
            try {
                Field field = current.getDeclaredField("lang");
                XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
                if ("http://www.w3.org/XML/1998/namespace".equals(xmlAttribute.namespace()) && field.getType() == Locale.class) {
                    field.setAccessible(true);
                    Locale presetLocale = (Locale)field.get(target);
                    if (presetLocale != null) {
                        return presetLocale;
                    }
                    if (parentLocale == null) break;
                    field.set(target, parentLocale);
                    return parentLocale;
                }
                current = current.getSuperclass();
            }
            catch (IllegalAccessException | NoSuchFieldException ignore) {
                current = current.getSuperclass();
            }
        }
        return parentLocale;
    }
}

