/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.util.LanguageUnmarshallerListener;

public final class XmppStreamDecoder
implements ReaderInterceptor {
    private static final QName STREAM_ID = new QName("id");
    private static final QName FROM = new QName("from");
    private static final QName TO = new QName("to");
    private static final QName VERSION = new QName("version");
    private static final QName LANG = new QName("http://www.w3.org/XML/1998/namespace", "lang");
    private final XMLInputFactory inputFactory;
    private final Supplier<Unmarshaller> unmarshaller;
    private final String contentNamespace;
    private boolean doRestart;

    public XmppStreamDecoder(XMLInputFactory inputFactory, Supplier<Unmarshaller> unmarshaller, String contentNamespace) {
        this.unmarshaller = unmarshaller;
        this.inputFactory = inputFactory;
        this.contentNamespace = contentNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void decode(Reader reader, Consumer<StreamElement> streamElementConsumer) throws StreamErrorException {
        XMLEventReader xmlEventReader = null;
        try {
            try {
                XMLEvent xmlEvent;
                this.doRestart = false;
                xmlEventReader = this.inputFactory.createXMLEventReader(reader);
                StreamHeader streamHeader = null;
                while (!this.doRestart && (xmlEvent = xmlEventReader.peek()) != null) {
                    switch (xmlEvent.getEventType()) {
                        case 1: {
                            StartElement startElement = xmlEvent.asStartElement();
                            if ("stream".equals(startElement.getName().getLocalPart()) && "http://etherx.jabber.org/streams".equals(startElement.getName().getNamespaceURI())) {
                                Attribute idAttribute = startElement.getAttributeByName(STREAM_ID);
                                Attribute fromAttribute = startElement.getAttributeByName(FROM);
                                Attribute toAttribute = startElement.getAttributeByName(TO);
                                Attribute versionAttribute = startElement.getAttributeByName(VERSION);
                                Attribute langAttribute = startElement.getAttributeByName(LANG);
                                Jid from = fromAttribute != null ? Jid.ofEscaped((CharSequence)fromAttribute.getValue()) : null;
                                Jid to = toAttribute != null ? Jid.ofEscaped((CharSequence)toAttribute.getValue()) : null;
                                String id = idAttribute != null ? idAttribute.getValue() : null;
                                String version = versionAttribute != null ? versionAttribute.getValue() : null;
                                Locale lang = langAttribute != null ? Locale.forLanguageTag(langAttribute.getValue()) : null;
                                ArrayList<QName> additionalNamespaces = new ArrayList<QName>();
                                Iterator<Namespace> namespaces = startElement.getNamespaces();
                                while (namespaces.hasNext()) {
                                    Namespace namespace = namespaces.next();
                                    String namespaceUri = namespace.getNamespaceURI();
                                    if ("http://etherx.jabber.org/streams".equals(namespaceUri) || Objects.equals(namespaceUri, this.contentNamespace)) continue;
                                    additionalNamespaces.add(new QName(namespaceUri, "", namespace.getPrefix()));
                                }
                                streamHeader = StreamHeader.create(from, to, id, version, lang, this.contentNamespace, additionalNamespaces.toArray(new QName[0]));
                                streamElementConsumer.accept(streamHeader);
                                xmlEventReader.nextEvent();
                                break;
                            }
                            if (streamHeader != null) {
                                this.unmarshaller.get().setListener((Unmarshaller.Listener)new LanguageUnmarshallerListener(streamHeader.getLanguage()));
                            }
                            StreamElement object = (StreamElement)this.unmarshaller.get().unmarshal(xmlEventReader);
                            streamElementConsumer.accept(object);
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 9: 
                        case 11: 
                        case 14: 
                        case 15: {
                            throw new StreamErrorException(new StreamError(Condition.RESTRICTED_XML));
                        }
                        default: {
                            xmlEventReader.nextEvent();
                        }
                    }
                    if (!xmlEvent.isEndElement()) continue;
                    streamElementConsumer.accept(StreamHeader.CLOSING_STREAM_TAG);
                }
            }
            finally {
                if (xmlEventReader != null) {
                    xmlEventReader.close();
                }
            }
        }
        catch (StreamErrorException e) {
            throw e;
        }
        catch (XMLStreamException e) {
            throw new StreamErrorException(new StreamError(Condition.NOT_WELL_FORMED), (Throwable)e);
        }
        catch (Exception e) {
            throw new StreamErrorException(new StreamError(Condition.INTERNAL_SERVER_ERROR), (Throwable)e);
        }
    }

    public synchronized void restart() {
        this.doRestart = true;
    }

    @Override
    public void process(Reader reader, Consumer<StreamElement> streamElement, ReaderInterceptorChain chain) throws Exception {
        this.decode(reader, streamElement);
        chain.proceed(reader, streamElement);
    }
}

