/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.util.ByteBufferOutputStream;
import rocks.xmpp.util.XmppUtils;

public final class XmppStreamEncoder
implements WriterInterceptor {
    private final XMLOutputFactory outputFactory;
    private final Supplier<Marshaller> marshaller;
    private final Function<StreamElement, Boolean> writeStreamNamespace;
    private String contentNamespace;

    public XmppStreamEncoder(XMLOutputFactory outputFactory, Supplier<Marshaller> marshaller, Function<StreamElement, Boolean> writeStreamNamespace) {
        this.marshaller = marshaller;
        this.outputFactory = outputFactory;
        this.writeStreamNamespace = writeStreamNamespace;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final ByteBuffer encode(StreamElement streamElement) throws StreamErrorException {
        try (ByteBufferOutputStream outputStream = new ByteBufferOutputStream(512, false);){
            ByteBuffer byteBuffer;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
                this.encode(streamElement, writer);
                byteBuffer = outputStream.getBuffer().flip();
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new StreamErrorException(new StreamError(Condition.INTERNAL_SERVER_ERROR), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encode(StreamElement streamElement, Writer writer) throws StreamErrorException {
        try (XMLStreamWriter streamWriter = null;){
            if (streamElement instanceof StreamHeader) {
                try (StringWriter out = new StringWriter();){
                    this.contentNamespace = ((StreamHeader)streamElement).getContentNamespace();
                    streamWriter = this.outputFactory.createXMLStreamWriter(out);
                    ((StreamHeader)streamElement).writeTo(streamWriter);
                    writer.write(((Object)out).toString());
                }
                return;
            }
            if (streamElement == StreamHeader.CLOSING_STREAM_TAG) {
                writer.write(StreamHeader.CLOSING_STREAM_TAG.toString());
                writer.flush();
                return;
            }
            streamWriter = XmppUtils.createXmppStreamWriter(this.outputFactory.createXMLStreamWriter(writer), this.writeStreamNamespace.apply(streamElement));
            streamWriter.setDefaultNamespace(this.contentNamespace != null ? this.contentNamespace : "");
            Marshaller m = this.marshaller.get();
            m.setProperty("jaxb.fragment", (Object)true);
            m.marshal((Object)streamElement, streamWriter);
            streamWriter.flush();
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            throw new StreamErrorException(new StreamError(Condition.INTERNAL_SERVER_ERROR), e);
        }
    }

    @Override
    public void process(StreamElement streamElement, Writer writer, WriterInterceptorChain chain) throws Exception {
        this.encode(streamElement, writer);
        chain.proceed(streamElement, writer);
    }
}

