/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueuedExecutorService
extends AbstractExecutorService {
    final Object awaitTerminationLock;
    private final Executor delegate;
    private final AtomicBoolean hasRunningTask;
    private final AtomicBoolean shutdown;
    private final BlockingQueue<Runnable> tasks;

    public QueuedExecutorService(Executor delegate) {
        this.delegate = delegate;
        this.hasRunningTask = new AtomicBoolean(false);
        this.awaitTerminationLock = new Object();
        this.shutdown = new AtomicBoolean(false);
        this.tasks = new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, false);
    }

    void execute(Runnable command, boolean ignoreShutdown) {
        if (!ignoreShutdown && this.isShutdown()) {
            throw new RejectedExecutionException("Executor Service is shutdown");
        }
        this.tasks.add(command);
        this.poll();
    }

    @Override
    public void shutdown() {
        this.shutdown.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        this.tasks.drainTo(result);
        return result;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.tasks.isEmpty() && !this.hasRunningTask.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        Object object = this.awaitTerminationLock;
        synchronized (object) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long now = System.nanoTime();
                TimeUnit.NANOSECONDS.timedWait(this.awaitTerminationLock, nanos);
                nanos -= System.nanoTime() - now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        Runnable task = (Runnable)this.tasks.peek();
        if (task != null && !this.hasRunningTask.getAndSet(true)) {
            this.tasks.remove(task);
            try {
                this.delegate.execute(() -> this.doExecute(task));
            }
            catch (RejectedExecutionException e) {
                this.hasRunningTask.set(false);
                throw e;
            }
        }
        if (task == null) {
            Object object = this.awaitTerminationLock;
            synchronized (object) {
                this.awaitTerminationLock.notifyAll();
            }
        }
    }

    private void doExecute(Runnable task) {
        try {
            task.run();
        }
        finally {
            this.hasRunningTask.set(false);
            this.poll();
        }
    }
}

