/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.NeptuneClientBuilder;
import software.amazon.awssdk.services.neptune.model.DBCluster;
import software.amazon.awssdk.services.neptune.model.DBClusterMember;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.Filter;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.NeptuneException;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.ClusterMetadataSupplier;
import software.amazon.neptune.cluster.CommonClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.neptune.cluster.NeptuneInstanceMetadata;
import software.amazon.utils.RegionUtils;

class GetEndpointsFromNeptuneManagementApi
implements ClusterEndpointsFetchStrategy,
ClusterMetadataSupplier {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointsFromNeptuneManagementApi.class);
    private static final String ANNOTATION_KEY_PREFIX = "neptune:annotation:";
    private final ClusterEndpointsFetchStrategy innerStrategy;
    private final String clusterId;
    private final String region;
    private final String iamProfile;
    private final AwsCredentialsProvider credentials;
    private final AtomicReference<NeptuneClusterMetadata> cachedClusterMetadata = new AtomicReference();
    private final ClientOverrideConfiguration clientConfiguration;
    private final SdkHttpClient.Builder<?> httpClientBuilder;

    GetEndpointsFromNeptuneManagementApi(String clusterId) {
        this(clusterId, RegionUtils.getCurrentRegionName());
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region) {
        this(clusterId, region, "default");
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, String iamProfile) {
        this(clusterId, region, iamProfile, null, null, null);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, String iamProfile, ClientOverrideConfiguration clientConfiguration) {
        this(clusterId, region, iamProfile, null, clientConfiguration, null);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, AwsCredentialsProvider credentials) {
        this(clusterId, region, "default", credentials, null, null);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientConfiguration) {
        this(clusterId, region, "default", credentials, clientConfiguration, null);
    }

    GetEndpointsFromNeptuneManagementApi(String clusterId, String region, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientConfiguration, SdkHttpClient.Builder<?> httpClientBuilder) {
        this(clusterId, region, "default", credentials, clientConfiguration, null);
    }

    private GetEndpointsFromNeptuneManagementApi(String clusterId, String region, String iamProfile, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientConfiguration, SdkHttpClient.Builder<?> httpClientBuilder) {
        this.innerStrategy = new CommonClusterEndpointsFetchStrategy(this);
        this.clusterId = clusterId;
        this.region = region;
        this.iamProfile = iamProfile;
        this.credentials = credentials;
        this.clientConfiguration = clientConfiguration;
        this.httpClientBuilder = httpClientBuilder;
    }

    @Override
    public NeptuneClusterMetadata refreshClusterMetadata() {
        try {
            NeptuneClientBuilder builder = NeptuneClient.builder();
            if (this.clientConfiguration != null) {
                builder = (NeptuneClientBuilder)builder.overrideConfiguration(this.clientConfiguration);
            }
            if (this.httpClientBuilder != null) {
                builder = (NeptuneClientBuilder)builder.httpClientBuilder(this.httpClientBuilder);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.region)) {
                builder = (NeptuneClientBuilder)builder.region(Region.of((String)this.region));
            }
            if (this.credentials != null) {
                builder = (NeptuneClientBuilder)builder.credentialsProvider(this.credentials);
            } else if (!this.iamProfile.equals("default")) {
                builder = (NeptuneClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.iamProfile));
            }
            NeptuneClient neptune = (NeptuneClient)builder.build();
            DescribeDbClustersResponse describeDBClustersResult = neptune.describeDBClusters((DescribeDbClustersRequest)DescribeDbClustersRequest.builder().dbClusterIdentifier(this.clusterId).build());
            if (describeDBClustersResult.dbClusters().isEmpty()) {
                throw new IllegalStateException(String.format("Unable to find cluster %s", this.clusterId));
            }
            DBCluster dbCluster = (DBCluster)describeDBClustersResult.dbClusters().get(0);
            String clusterEndpoint = dbCluster.endpoint();
            String readerEndpoint = dbCluster.readerEndpoint();
            List dbClusterMembers = dbCluster.dbClusterMembers();
            Optional<DBClusterMember> clusterWriter = dbClusterMembers.stream().filter(DBClusterMember::isClusterWriter).findFirst();
            String primary = clusterWriter.map(DBClusterMember::dbInstanceIdentifier).orElse("");
            List replicas = dbClusterMembers.stream().filter(dbClusterMember -> dbClusterMember.isClusterWriter() == false).map(DBClusterMember::dbInstanceIdentifier).collect(Collectors.toList());
            DescribeDbInstancesRequest describeDBInstancesRequest = (DescribeDbInstancesRequest)DescribeDbInstancesRequest.builder().filters(Collections.singletonList((Filter)Filter.builder().name("db-cluster-id").values(new String[]{dbCluster.dbClusterIdentifier()}).build())).build();
            DescribeDbInstancesResponse describeDBInstancesResult = neptune.describeDBInstances(describeDBInstancesRequest);
            ArrayList<NeptuneInstanceMetadata> instances = new ArrayList<NeptuneInstanceMetadata>();
            describeDBInstancesResult.dbInstances().forEach(c -> {
                String role = "unknown";
                if (primary.equals(c.dbInstanceIdentifier())) {
                    role = "writer";
                }
                if (replicas.contains(c.dbInstanceIdentifier())) {
                    role = "reader";
                }
                String address = c.endpoint() == null ? null : c.endpoint().address();
                Map<String, String> tags = this.getTags(c.dbInstanceArn(), neptune);
                Map<String, String> annotations = this.getAnnotations(tags);
                instances.add(new NeptuneInstanceMetadata().withInstanceId(c.dbInstanceIdentifier()).withRole(role).withAddress(address).withStatus(c.dbInstanceStatus()).withAvailabilityZone(c.availabilityZone()).withInstanceType(c.dbInstanceClass()).withTags(tags).withAnnotations(annotations));
            });
            neptune.close();
            NeptuneClusterMetadata clusterMetadata = new NeptuneClusterMetadata().withInstances(instances).withClusterEndpoint(clusterEndpoint).withReaderEndpoint(readerEndpoint);
            this.cachedClusterMetadata.set(clusterMetadata);
            return clusterMetadata;
        }
        catch (NeptuneException e) {
            if (e.isThrottlingException()) {
                logger.warn("Calls to the Neptune Management API are being throttled. Reduce the refresh rate and stagger refresh agent requests, or use a NeptuneEndpointsInfoLambda proxy.");
                NeptuneClusterMetadata clusterMetadata = this.cachedClusterMetadata.get();
                if (clusterMetadata != null) {
                    logger.warn("Returning cached cluster metadata");
                    return clusterMetadata;
                }
                throw e;
            }
            throw e;
        }
    }

    @Override
    public NeptuneClusterMetadata getClusterMetadata() {
        NeptuneClusterMetadata clusterMetadata = this.cachedClusterMetadata.get();
        if (clusterMetadata == null) {
            return this.refreshClusterMetadata();
        }
        return clusterMetadata;
    }

    @Override
    public ClusterMetadataSupplier clusterMetadataSupplier() {
        return this;
    }

    @Override
    public Map<? extends EndpointsSelector, EndpointCollection> getEndpoints(Collection<? extends EndpointsSelector> selectors, boolean refresh) {
        return this.innerStrategy.getEndpoints(selectors, refresh);
    }

    private Map<String, String> getTags(String dbInstanceArn, NeptuneClient neptune) {
        List tagList = neptune.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceName(dbInstanceArn).build()).tagList();
        HashMap<String, String> tags = new HashMap<String, String>();
        tagList.forEach(t -> tags.put(t.key(), t.value()));
        return tags;
    }

    private Map<String, String> getAnnotations(Map<String, String> tags) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            String key = tag.getKey();
            if (!key.startsWith(ANNOTATION_KEY_PREFIX)) continue;
            annotations.put(key.substring(ANNOTATION_KEY_PREFIX.length()), tag.getValue());
        }
        return annotations;
    }
}

