/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.ops.BaseOperationFactory;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.MultiGetOperationCallback;
import net.spy.memcached.ops.MultiGetsOperationCallback;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.NoopOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.SASLAuthOperation;
import net.spy.memcached.ops.SASLMechsOperation;
import net.spy.memcached.ops.SASLStepOperation;
import net.spy.memcached.ops.StatsOperation;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.ops.VersionOperation;
import net.spy.memcached.protocol.binary.ConcatenationOperationImpl;
import net.spy.memcached.protocol.binary.DeleteOperationImpl;
import net.spy.memcached.protocol.binary.FlushOperationImpl;
import net.spy.memcached.protocol.binary.GetOperationImpl;
import net.spy.memcached.protocol.binary.MultiGetOperationImpl;
import net.spy.memcached.protocol.binary.MutatorOperationImpl;
import net.spy.memcached.protocol.binary.NoopOperationImpl;
import net.spy.memcached.protocol.binary.SASLAuthOperationImpl;
import net.spy.memcached.protocol.binary.SASLMechsOperationImpl;
import net.spy.memcached.protocol.binary.SASLStepOperationImpl;
import net.spy.memcached.protocol.binary.StatsOperationImpl;
import net.spy.memcached.protocol.binary.StoreOperationImpl;
import net.spy.memcached.protocol.binary.TouchOperationImpl;
import net.spy.memcached.protocol.binary.VersionOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperationFactory
extends BaseOperationFactory {
    @Override
    public DeleteOperation delete(String key, OperationCallback operationCallback) {
        return new DeleteOperationImpl(key, operationCallback);
    }

    @Override
    public FlushOperation flush(int delay, OperationCallback cb) {
        return new FlushOperationImpl(cb);
    }

    @Override
    public GetAndTouchOperation getAndTouch(String key, int expiration, GetAndTouchOperation.Callback cb) {
        return new GetOperationImpl(key, expiration, cb);
    }

    @Override
    public GetOperation get(String key, GetOperation.Callback callback) {
        return new GetOperationImpl(key, callback);
    }

    @Override
    public GetOperation get(Collection<String> value, GetOperation.Callback cb) {
        return new MultiGetOperationImpl(value, cb);
    }

    @Override
    public GetlOperation getl(String key, int exp, GetlOperation.Callback cb) {
        return new GetOperationImpl(key, exp, cb);
    }

    @Override
    public GetsOperation gets(String key, GetsOperation.Callback cb) {
        return new GetOperationImpl(key, cb);
    }

    @Override
    public MutatorOperation mutate(Mutator m, String key, int by, long def, int exp, OperationCallback cb) {
        return new MutatorOperationImpl(m, key, by, def, exp, cb);
    }

    @Override
    public StatsOperation stats(String arg, StatsOperation.Callback cb) {
        return new StatsOperationImpl(arg, cb);
    }

    @Override
    public StoreOperation store(StoreType storeType, String key, int flags, int exp, byte[] data, OperationCallback cb) {
        return new StoreOperationImpl(storeType, key, flags, exp, data, 0L, cb);
    }

    @Override
    public KeyedOperation touch(String key, int expiration, OperationCallback cb) {
        return new TouchOperationImpl(key, expiration, cb);
    }

    @Override
    public VersionOperation version(OperationCallback cb) {
        return new VersionOperationImpl(cb);
    }

    @Override
    public NoopOperation noop(OperationCallback cb) {
        return new NoopOperationImpl(cb);
    }

    @Override
    public CASOperation cas(StoreType type, String key, long casId, int flags, int exp, byte[] data, OperationCallback cb) {
        return new StoreOperationImpl(type, key, flags, exp, data, casId, cb);
    }

    @Override
    public ConcatenationOperation cat(ConcatenationType catType, long casId, String key, byte[] data, OperationCallback cb) {
        return new ConcatenationOperationImpl(catType, key, data, casId, cb);
    }

    @Override
    protected Collection<? extends Operation> cloneGet(KeyedOperation op) {
        ArrayList<GetsOperation> rv = new ArrayList<GetsOperation>();
        MultiGetOperationCallback getCb = null;
        MultiGetsOperationCallback getsCb = null;
        if (op.getCallback() instanceof GetOperation.Callback) {
            getCb = new MultiGetOperationCallback(op.getCallback(), op.getKeys().size());
        } else {
            getsCb = new MultiGetsOperationCallback(op.getCallback(), op.getKeys().size());
        }
        for (String k : op.getKeys()) {
            rv.add((GetsOperation)(getCb == null ? this.gets(k, getsCb) : this.get(k, (GetOperation.Callback)getCb)));
        }
        return rv;
    }

    @Override
    public SASLAuthOperation saslAuth(String[] mech, String serverName, Map<String, ?> props, CallbackHandler cbh, OperationCallback cb) {
        return new SASLAuthOperationImpl(mech, serverName, props, cbh, cb);
    }

    @Override
    public SASLMechsOperation saslMechs(OperationCallback cb) {
        return new SASLMechsOperationImpl(cb);
    }

    @Override
    public SASLStepOperation saslStep(String[] mech, byte[] challenge, String serverName, Map<String, ?> props, CallbackHandler cbh, OperationCallback cb) {
        return new SASLStepOperationImpl(mech, challenge, serverName, props, cbh, cb);
    }
}

