/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcatenationOperationImpl
extends OperationImpl
implements ConcatenationOperation {
    private static final int APPEND = 14;
    private static final int PREPEND = 15;
    private final String key;
    private final long cas;
    private final ConcatenationType catType;
    private final byte[] data;

    private static int cmdMap(ConcatenationType t) {
        int rv = -1;
        switch (t) {
            case append: {
                rv = 14;
                break;
            }
            case prepend: {
                rv = 15;
            }
        }
        assert (rv != -1) : "Unhandled store type:  " + (Object)((Object)t);
        return rv;
    }

    public ConcatenationOperationImpl(ConcatenationType t, String k, byte[] d, long c, OperationCallback cb) {
        super(ConcatenationOperationImpl.cmdMap(t), ConcatenationOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.data = d;
        this.cas = c;
        this.catType = t;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, this.cas, this.data, new Object[0]);
    }

    @Override
    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus baseStatus = super.getStatusForErrorCode(errCode, errPl);
        if (baseStatus != null) {
            return baseStatus;
        }
        OperationStatus rv = null;
        switch (errCode) {
            case 2: {
                rv = EXISTS_STATUS;
                break;
            }
            case 1: {
                rv = NOT_FOUND_STATUS;
                break;
            }
            case 5: {
                rv = NOT_FOUND_STATUS;
            }
        }
        return rv;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public long getCasValue() {
        return this.cas;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ConcatenationType getStoreType() {
        return this.catType;
    }
}

