/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeleteOperationImpl
extends OperationImpl
implements DeleteOperation {
    private static final int CMD = 4;
    private final String key;
    private final long cas;

    public DeleteOperationImpl(String k, OperationCallback cb) {
        this(k, 0L, cb);
    }

    public DeleteOperationImpl(String k, long c, OperationCallback cb) {
        super(4, DeleteOperationImpl.generateOpaque(), cb);
        this.key = k;
        this.cas = c;
    }

    @Override
    public void initialize() {
        this.prepareBuffer(this.key, this.cas, EMPTY_BYTES, new Object[0]);
    }

    @Override
    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus baseStatus = super.getStatusForErrorCode(errCode, errPl);
        if (baseStatus != null) {
            return baseStatus;
        }
        return errCode == 1 ? NOT_FOUND_STATUS : null;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

