/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.binary.OperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MutatorOperationImpl
extends OperationImpl
implements MutatorOperation {
    private static final int CMD_INCR = 5;
    private static final int CMD_DECR = 6;
    private final Mutator mutator;
    private final String key;
    private final long by;
    private final int exp;
    private final long def;

    public MutatorOperationImpl(Mutator m, String k, long b, long d, int e, OperationCallback cb) {
        super(m == Mutator.incr ? 5 : 6, MutatorOperationImpl.generateOpaque(), cb);
        assert (d >= 0L) : "Default value is below zero";
        this.mutator = m;
        this.key = k;
        this.by = b;
        this.exp = e;
        this.def = d;
    }

    @Override
    public void initialize() {
        byte[] defBytes = new byte[]{(byte)(this.def >> 56 & 0xFFL), (byte)(this.def >> 48 & 0xFFL), (byte)(this.def >> 40 & 0xFFL), (byte)(this.def >> 32 & 0xFFL), (byte)(this.def >> 24 & 0xFFL), (byte)(this.def >> 16 & 0xFFL), (byte)(this.def >> 8 & 0xFFL), (byte)(this.def & 0xFFL)};
        this.prepareBuffer(this.key, 0L, EMPTY_BYTES, this.by, defBytes, this.exp);
    }

    @Override
    protected OperationStatus getStatusForErrorCode(int errCode, byte[] errPl) {
        OperationStatus baseStatus = super.getStatusForErrorCode(errCode, errPl);
        if (baseStatus != null) {
            return baseStatus;
        }
        return errCode == 1 ? NOT_FOUND_STATUS : null;
    }

    @Override
    protected void decodePayload(byte[] pl) {
        this.getCallback().receivedStatus(new OperationStatus(true, String.valueOf(MutatorOperationImpl.decodeLong(pl, 0))));
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public int getBy() {
        return (int)this.by;
    }

    @Override
    public long getDefault() {
        return this.def;
    }

    @Override
    public int getExpiration() {
        return this.exp;
    }

    @Override
    public Mutator getType() {
        return this.mutator;
    }
}

