/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.text.ParseException;
import java.util.Observable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.vbucket.BucketMonitorPipelineFactory;
import net.spy.memcached.vbucket.BucketUpdateResponseHandler;
import net.spy.memcached.vbucket.ConfigurationProviderHTTP;
import net.spy.memcached.vbucket.ConnectionException;
import net.spy.memcached.vbucket.config.Bucket;
import net.spy.memcached.vbucket.config.ConfigurationParser;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class BucketMonitor
extends Observable {
    private final URI cometStreamURI;
    private Bucket bucket;
    private final String httpUser;
    private final String httpPass;
    private final ChannelFactory factory;
    private Channel channel;
    private final String host;
    private final int port;
    private ConfigurationParser configParser;
    private BucketUpdateResponseHandler handler;
    public static final String CLIENT_SPEC_VER = "1.0";

    public BucketMonitor(URI cometStreamURI, String bucketname, String username, String password, ConfigurationParser configParser) {
        String scheme;
        if (cometStreamURI == null) {
            throw new IllegalArgumentException("cometStreamURI cannot be NULL");
        }
        String string = scheme = cometStreamURI.getScheme() == null ? "http" : cometStreamURI.getScheme();
        if (!scheme.equals("http")) {
            throw new UnsupportedOperationException("Only http is supported.");
        }
        this.cometStreamURI = cometStreamURI;
        this.httpUser = username;
        this.httpPass = password;
        this.configParser = configParser;
        this.host = cometStreamURI.getHost();
        this.port = cometStreamURI.getPort() == -1 ? 80 : cometStreamURI.getPort();
        this.factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    }

    public void startMonitor() {
        if (this.channel != null) {
            Logger.getLogger(BucketMonitor.class.getName()).log(Level.WARNING, "Bucket monitor is already started.");
            return;
        }
        this.createChannel();
        this.handler = (BucketUpdateResponseHandler)this.channel.getPipeline().get(BucketUpdateResponseHandler.class);
        this.handler.setBucketMonitor(this);
        HttpRequest request = this.prepareRequest(this.cometStreamURI, this.host);
        this.channel.write((Object)request);
        try {
            String response = this.handler.getLastResponse();
            this.logFiner("Getting server list returns this last chunked response:\n" + response);
            Bucket bucketToMonitor = this.configParser.parseBucket(response);
            this.setBucket(bucketToMonitor);
        }
        catch (ParseException ex) {
            Logger.getLogger(BucketMonitor.class.getName()).log(Level.WARNING, "Invalid client configuration received from server.  Staying with existing configuration.", ex);
            Logger.getLogger(BucketMonitor.class.getName()).log(Level.FINE, "Invalid client configuration received:\n" + this.handler.getLastResponse() + "\n");
        }
    }

    protected void createChannel() {
        ClientBootstrap bootstrap = new ClientBootstrap(this.factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new BucketMonitorPipelineFactory());
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        this.channel = future.awaitUninterruptibly().getChannel();
        if (!future.isSuccess()) {
            bootstrap.releaseExternalResources();
            throw new ConnectionException("Could not connect to any pool member.");
        }
        assert (this.channel != null);
    }

    protected HttpRequest prepareRequest(URI uri, String host) {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.toASCIIString());
        request.setHeader("Host", host);
        if (this.getHttpUser() != null) {
            request.setHeader("Authorization", ConfigurationProviderHTTP.buildAuthHeader(this.getHttpUser(), this.getHttpPass()));
        }
        request.setHeader("Connection", "close");
        request.setHeader("Cache-Control", "no-cache");
        request.setHeader("Accept", "application/json");
        request.setHeader("User-Agent", "spymemcached vbucket client");
        request.setHeader("X-memcachekv-Store-Client-Specification-Version", CLIENT_SPEC_VER);
        return request;
    }

    private void setBucket(Bucket bucket) {
        if (this.bucket == null || !this.bucket.equals(bucket)) {
            this.bucket = bucket;
            this.setChanged();
            this.notifyObservers(this.bucket);
        }
    }

    public String getHttpUser() {
        return this.httpUser;
    }

    public String getHttpPass() {
        return this.httpPass;
    }

    private void logFiner(String msg) {
        Logger.getLogger(BucketMonitor.class.getName()).log(Level.FINER, msg);
    }

    public void shutdown() {
        this.shutdown(-1L, TimeUnit.MILLISECONDS);
    }

    public void shutdown(long timeout, TimeUnit unit) {
        this.deleteObservers();
        if (this.channel != null) {
            this.channel.close().awaitUninterruptibly(timeout, unit);
        }
        this.factory.releaseExternalResources();
    }

    protected void invalidate() {
        try {
            String response = this.handler.getLastResponse();
            Bucket updatedBucket = this.configParser.parseBucket(response);
            this.setBucket(updatedBucket);
        }
        catch (ParseException e) {
            Logger.getLogger(BucketMonitor.class.getName()).log(Level.SEVERE, "Invalid client configuration received from server.  Staying with existing configuration.", e);
        }
    }

    public void setConfigParser(ConfigurationParser configParser) {
        this.configParser = configParser;
    }
}

