/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.vbucket.config;

import java.util.EnumMap;
import java.util.Map;
import net.spy.memcached.vbucket.config.Port;
import net.spy.memcached.vbucket.config.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final Status status;
    private final String hostname;
    private final Map<Port, String> ports;

    public Node(Status status, String hostname, Map<Port, String> ports) {
        this.status = status;
        this.hostname = hostname;
        this.ports = new EnumMap<Port, String>(ports);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Map<Port, String> getPorts() {
        return this.ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (!this.hostname.equals(node.hostname)) {
            return false;
        }
        if (this.status != node.status) {
            return false;
        }
        return ((Object)this.ports).equals(node.ports);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + this.hostname.hashCode();
        result = 31 * result + ((Object)this.ports).hashCode();
        return result;
    }
}

