/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class MutatorOperationImpl
extends OperationImpl
implements MutatorOperation {
    public static final int OVERHEAD = 32;
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND");
    private final Mutator mutator;
    private final String key;
    private final long amount;

    public MutatorOperationImpl(Mutator m, String k, long amt, OperationCallback c) {
        super(c);
        this.mutator = m;
        this.key = k;
        this.amount = amt;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Result:  %s", line);
        OperationStatus found = null;
        found = line.equals("NOT_FOUND") ? NOT_FOUND : new OperationStatus(true, line);
        this.getCallback().receivedStatus(found);
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        int size = KeyUtil.getKeyBytes(this.key).length + 32;
        ByteBuffer b = ByteBuffer.allocate(size);
        this.setArguments(b, this.mutator.name(), this.key, this.amount);
        b.flip();
        this.setBuffer(b);
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public long getBy() {
        return this.amount;
    }

    @Override
    public long getDefault() {
        return -1L;
    }

    @Override
    public int getExpiration() {
        return -1;
    }

    @Override
    public Mutator getType() {
        return this.mutator;
    }

    public String toString() {
        return "Cmd: " + this.mutator.name() + " Key: " + this.key + " Amount: " + this.amount;
    }
}

