/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.support.finder;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import com.sun.xacml.support.finder.PolicyCollection;
import com.sun.xacml.support.finder.PolicyReader;
import com.sun.xacml.support.finder.TopLevelPolicyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePolicyModule
extends PolicyFinderModule {
    private File schemaFile = null;
    private Set fileNames = new HashSet();
    private PolicyCollection policies = new PolicyCollection();
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$support$finder$FilePolicyModule == null ? (class$com$sun$xacml$support$finder$FilePolicyModule = FilePolicyModule.class$("com.sun.xacml.support.finder.FilePolicyModule")) : class$com$sun$xacml$support$finder$FilePolicyModule).getName());
    static /* synthetic */ Class class$com$sun$xacml$support$finder$FilePolicyModule;

    public FilePolicyModule() {
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public FilePolicyModule(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public FilePolicyModule(String schemaFile) {
        this(schemaFile != null ? new File(schemaFile) : null);
    }

    public FilePolicyModule(List fileNames) {
        this();
        if (fileNames != null) {
            this.fileNames.addAll(fileNames);
        }
    }

    public FilePolicyModule(List fileNames, String schemaFile) {
        this(schemaFile);
        if (fileNames != null) {
            this.fileNames.addAll(fileNames);
        }
    }

    public boolean addPolicy(String filename) {
        return this.fileNames.add(filename);
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        PolicyReader reader = new PolicyReader(finder, logger, this.schemaFile);
        Iterator it = this.fileNames.iterator();
        while (it.hasNext()) {
            String fname = (String)it.next();
            try {
                AbstractPolicy policy = reader.readPolicy(new FileInputStream(fname));
                this.policies.addPolicy(policy);
            }
            catch (FileNotFoundException fnfe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "File couldn't be read: " + fname, fnfe);
            }
            catch (ParsingException pe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Error reading policy from file " + fname, pe);
            }
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.policies.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

