/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FormColors {
    public static final String TITLE = "org.eclipse.ui.forms.TITLE";
    public static final String BORDER = "org.eclipse.ui.forms.BORDER";
    public static final String SEPARATOR = "org.eclipse.ui.forms.SEPARATOR";
    protected Map colorRegistry = new HashMap(10);
    protected Color background;
    protected Color foreground;
    private boolean shared;
    protected Display display;
    protected Color border;

    public FormColors(Display display) {
        this.display = display;
        this.initialize();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void initialize() {
        this.background = this.display.getSystemColor(25);
        this.foreground = this.display.getSystemColor(24);
        this.initializeColorTable();
        this.updateBorderColor();
    }

    protected void initializeColorTable() {
        this.createColor(BORDER, 195, 191, 179);
        this.createColor(SEPARATOR, 152, 170, 203);
        this.createColor(TITLE, 102, 120, 153);
    }

    public Color createColor(String key, RGB rgb) {
        return this.createColor(key, rgb.red, rgb.green, rgb.blue);
    }

    public Color createColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.display, r, g, b);
        this.colorRegistry.put(key, c);
        return c;
    }

    protected void updateBorderColor() {
        this.border = this.isWhiteBackground() ? this.getColor(BORDER) : this.display.getSystemColor(22);
    }

    public void setBackground(Color bg) {
        this.background = bg;
        this.updateBorderColor();
    }

    public void setForeground(Color fg) {
        this.foreground = fg;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBorderColor() {
        return this.border;
    }

    public boolean isWhiteBackground() {
        return this.background.getRed() == 255 && this.background.getGreen() == 255 && this.background.getBlue() == 255;
    }

    public Color getColor(String key) {
        return (Color)this.colorRegistry.get(key);
    }

    public void dispose() {
        Iterator e = this.colorRegistry.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
        this.colorRegistry = null;
    }

    public void markShared() {
        this.shared = true;
    }

    public boolean isShared() {
        return this.shared;
    }
}

