/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ManagedForm
implements IManagedForm {
    private Object input;
    private ScrolledForm form;
    private FormToolkit toolkit;
    private boolean ownsToolkit;
    private Vector parts = new Vector();

    public ManagedForm(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.ownsToolkit = true;
        this.form = this.toolkit.createScrolledForm(parent);
    }

    public ManagedForm(FormToolkit toolkit, ScrolledForm form) {
        this.form = form;
        this.toolkit = toolkit;
    }

    public void addPart(IFormPart part) {
        this.parts.add(part);
    }

    public void removePart(IFormPart part) {
        this.parts.remove(part);
    }

    public IFormPart[] getParts() {
        return this.parts.toArray(new IFormPart[this.parts.size()]);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public void reflow(boolean changed) {
        this.form.reflow(changed);
    }

    public void fireSelectionChanged(IFormPart part, ISelection selection) {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart cpart = (IFormPart)this.parts.get(i);
            if (!part.equals(cpart) && cpart instanceof IPartSelectionListener) {
                ((IPartSelectionListener)((Object)cpart)).selectionChanged(part, selection);
            }
            ++i;
        }
    }

    public void initialize() {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.initialize(this);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.dispose();
            ++i;
        }
        if (this.ownsToolkit) {
            this.toolkit.dispose();
        }
    }

    public void refresh() {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.refresh();
            ++i;
        }
        this.form.reflow(true);
    }

    public void commit(boolean onSave) {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.commit(onSave);
            ++i;
        }
    }

    public void setInput(Object input) {
        this.input = input;
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart part = (IFormPart)this.parts.get(i);
            part.setFormInput(input);
            ++i;
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void setFocus() {
        if (this.parts.size() > 0) {
            IFormPart part = (IFormPart)this.parts.get(0);
            part.setFocus();
        }
    }

    public boolean isDirty() {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart part = (IFormPart)this.parts.get(i);
            if (part.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

