/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.editor;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.forms.editor.MultiPageKeyBindingEditorSite;

public class MultiPageKeyBindingService
implements IKeyBindingService {
    private MultiPageKeyBindingEditorSite site;
    private String[] scopes = new String[]{"org.eclipse.ui.globalScope"};
    private HashMap commandIdToActionMap = new HashMap();

    public MultiPageKeyBindingService(MultiPageKeyBindingEditorSite site) {
        this.site = site;
    }

    private boolean isActive() {
        return this.site.isActive();
    }

    public void activate() {
        Iterator i = this.commandIdToActionMap.values().iterator();
        while (i.hasNext()) {
            this.getOuterService().registerAction((IAction)i.next());
        }
    }

    public void deactivate() {
        Iterator i = this.commandIdToActionMap.values().iterator();
        while (i.hasNext()) {
            this.getOuterService().unregisterAction((IAction)i.next());
        }
    }

    private IKeyBindingService getOuterService() {
        return this.site.getMultiPageEditor().getSite().getKeyBindingService();
    }

    public String[] getScopes() {
        return (String[])this.scopes.clone();
    }

    public void setScopes(String[] scopes) {
        if (scopes == null || scopes.length < 1) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < scopes.length) {
            if (scopes[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.scopes = (String[])scopes.clone();
        if (this.isActive()) {
            this.getOuterService().setScopes(scopes);
        }
    }

    public void registerAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.put(command, action);
            if (this.isActive()) {
                this.getOuterService().registerAction(action);
            }
        }
    }

    public void unregisterAction(IAction action) {
        String command = action.getActionDefinitionId();
        if (command != null) {
            this.commandIdToActionMap.remove(command);
            if (this.isActive()) {
                this.getOuterService().unregisterAction(action);
            }
        }
    }

    public String getActiveAcceleratorScopeId() {
        return this.getScopes()[0];
    }

    public void setActiveAcceleratorScopeId(String scopeId) {
        this.setScopes(new String[]{scopeId});
    }

    public boolean processKey(KeyEvent event) {
        return false;
    }

    public void enable(boolean enable) {
    }
}

