/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.SWT;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.widgets.BreakSegment;
import org.eclipse.ui.forms.internal.widgets.BulletParagraph;
import org.eclipse.ui.forms.internal.widgets.HyperlinkSegment;
import org.eclipse.ui.forms.internal.widgets.ImageSegment;
import org.eclipse.ui.forms.internal.widgets.Paragraph;
import org.eclipse.ui.forms.internal.widgets.ParagraphSegment;
import org.eclipse.ui.forms.internal.widgets.TextSegment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormTextModel {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private Vector paragraphs;
    private HyperlinkSegment[] hyperlinks;
    private int selectedLinkIndex = -1;
    private HyperlinkSettings hyperlinkSettings;
    public static final String BOLD_FONT_ID = "f.____bold";

    public FormTextModel() {
        this.reset();
    }

    public Paragraph[] getParagraphs() {
        if (this.paragraphs == null) {
            return new Paragraph[0];
        }
        return this.paragraphs.toArray(new Paragraph[this.paragraphs.size()]);
    }

    public String getAccessibleText() {
        if (this.paragraphs == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.get(i);
            String text = paragraph.getAccessibleText();
            sbuf.append(text);
            ++i;
        }
        return sbuf.toString();
    }

    public void parseTaggedText(String taggedText, boolean expandURLs) {
        if (taggedText == null) {
            this.reset();
            return;
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(taggedText.getBytes("UTF8"));
            this.parseInputStream(stream, expandURLs);
        }
        catch (UnsupportedEncodingException e) {
            SWT.error((int)42, (Throwable)e);
        }
    }

    public void parseInputStream(InputStream is, boolean expandURLs) {
        documentBuilderFactory.setNamespaceAware(true);
        this.reset();
        try {
            DocumentBuilder parser = documentBuilderFactory.newDocumentBuilder();
            InputSource source = new InputSource(is);
            Document doc = parser.parse(source);
            this.processDocument(doc, expandURLs);
        }
        catch (ParserConfigurationException e) {
            SWT.error((int)13, (Throwable)e);
        }
        catch (SAXException e) {
            SWT.error((int)13, (Throwable)e);
        }
        catch (IOException e) {
            SWT.error((int)39, (Throwable)e);
        }
    }

    private void processDocument(Document doc, boolean expandURLs) {
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Paragraph p;
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                String text = child.getNodeValue();
                if (text != null && !this.isIgnorableWhiteSpace(text, true)) {
                    p = new Paragraph(true);
                    p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), null);
                    this.paragraphs.add(p);
                }
            } else if (child.getNodeType() == 1) {
                String tag = child.getNodeName().toLowerCase();
                if (tag.equals("p")) {
                    p = this.processParagraph(child, expandURLs);
                    if (p != null) {
                        this.paragraphs.add(p);
                    }
                } else if (tag.equals("li") && (p = this.processListItem(child, expandURLs)) != null) {
                    this.paragraphs.add(p);
                }
            }
            ++i;
        }
    }

    private Paragraph processParagraph(Node paragraph, boolean expandURLs) {
        NodeList children = paragraph.getChildNodes();
        NamedNodeMap atts = paragraph.getAttributes();
        Node addSpaceAtt = atts.getNamedItem("addVerticalSpace");
        boolean addSpace = true;
        if (addSpaceAtt == null) {
            addSpaceAtt = atts.getNamedItem("vspace");
        }
        if (addSpaceAtt != null) {
            String value = addSpaceAtt.getNodeValue();
            addSpace = value.equalsIgnoreCase("true");
        }
        Paragraph p = new Paragraph(addSpace);
        this.processSegments(p, children, expandURLs);
        return p;
    }

    private Paragraph processListItem(Node listItem, boolean expandURLs) {
        String value;
        NodeList children = listItem.getChildNodes();
        NamedNodeMap atts = listItem.getAttributes();
        Node addSpaceAtt = atts.getNamedItem("addVerticalSpace");
        Node styleAtt = atts.getNamedItem("style");
        Node valueAtt = atts.getNamedItem("value");
        Node indentAtt = atts.getNamedItem("indent");
        Node bindentAtt = atts.getNamedItem("bindent");
        int style = 1;
        int indent = -1;
        int bindent = -1;
        String text = null;
        boolean addSpace = true;
        if (addSpaceAtt != null) {
            value = addSpaceAtt.getNodeValue();
            addSpace = value.equalsIgnoreCase("true");
        }
        if (styleAtt != null) {
            value = styleAtt.getNodeValue();
            if (value.equalsIgnoreCase("text")) {
                style = 2;
            } else if (value.equalsIgnoreCase("image")) {
                style = 3;
            } else if (value.equalsIgnoreCase("bullet")) {
                style = 1;
            }
        }
        if (valueAtt != null) {
            text = valueAtt.getNodeValue();
            if (style == 3) {
                text = "i." + text;
            }
        }
        if (indentAtt != null) {
            value = indentAtt.getNodeValue();
            try {
                indent = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bindentAtt != null) {
            value = bindentAtt.getNodeValue();
            try {
                bindent = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        BulletParagraph p = new BulletParagraph(addSpace);
        p.setIndent(indent);
        p.setBulletIndent(bindent);
        p.setBulletStyle(style);
        p.setBulletText(text);
        this.processSegments(p, children, expandURLs);
        return p;
    }

    private void processSegments(Paragraph p, NodeList children, boolean expandURLs) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            ParagraphSegment segment = null;
            if (child.getNodeType() == 3) {
                String value = child.getNodeValue();
                if (value != null && !this.isIgnorableWhiteSpace(value, false)) {
                    p.parseRegularText(value, expandURLs, this.getHyperlinkSettings(), null);
                }
            } else if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                if (name.equalsIgnoreCase("img")) {
                    segment = this.processImageSegment(child);
                } else if (name.equalsIgnoreCase("a")) {
                    segment = this.processHyperlinkSegment(child, this.getHyperlinkSettings());
                } else if (name.equalsIgnoreCase("span")) {
                    this.processTextSegment(p, expandURLs, child);
                } else if (name.equalsIgnoreCase("b")) {
                    String text = this.getNodeText(child).trim();
                    String fontId = BOLD_FONT_ID;
                    p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), fontId);
                } else if (name.equalsIgnoreCase("br")) {
                    segment = new BreakSegment();
                }
            }
            if (segment != null) {
                p.addSegment(segment);
            }
            ++i;
        }
    }

    private boolean isIgnorableWhiteSpace(String text, boolean ignoreSpaces) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!(ignoreSpaces && c == ' ' || c == '\n' || c == '\r' || c == '\f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ParagraphSegment processImageSegment(Node image) {
        String value;
        ImageSegment segment = new ImageSegment();
        NamedNodeMap atts = image.getAttributes();
        Node id = atts.getNamedItem("href");
        Node align = atts.getNamedItem("align");
        if (id != null) {
            value = id.getNodeValue();
            segment.setObjectId("i." + value);
        }
        if (align != null) {
            value = align.getNodeValue().toLowerCase();
            if (value.equals("top")) {
                segment.setVerticalAlignment(1);
            } else if (value.equals("middle")) {
                segment.setVerticalAlignment(2);
            } else if (value.equals("bottom")) {
                segment.setVerticalAlignment(3);
            }
        }
        return segment;
    }

    private String getNodeText(Node node) {
        NodeList children = node.getChildNodes();
        String text = "";
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                text = String.valueOf(text) + child.getNodeValue();
            }
            ++i;
        }
        return text;
    }

    private ParagraphSegment processHyperlinkSegment(Node link, HyperlinkSettings settings) {
        String value;
        Node nowrap;
        String text = this.getNodeText(link);
        HyperlinkSegment segment = new HyperlinkSegment(text, settings, null);
        NamedNodeMap atts = link.getAttributes();
        Node href = atts.getNamedItem("href");
        if (href != null) {
            String value2 = href.getNodeValue();
            segment.setHref(value2);
        }
        if ((nowrap = atts.getNamedItem("nowrap")) != null && (value = nowrap.getNodeValue()) != null && value.equalsIgnoreCase("true")) {
            segment.setWordWrapAllowed(false);
        }
        return segment;
    }

    private void processTextSegment(Paragraph p, boolean expandURLs, Node textNode) {
        String text = this.getNodeText(textNode).trim();
        NamedNodeMap atts = textNode.getAttributes();
        Node font = atts.getNamedItem("font");
        Node color = atts.getNamedItem("color");
        String fontId = null;
        String colorId = null;
        if (font != null) {
            fontId = "f." + font.getNodeValue();
        }
        if (color != null) {
            colorId = "c." + color.getNodeValue();
        }
        p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), fontId, colorId);
    }

    public void parseRegularText(String regularText, boolean convertURLs) {
        this.reset();
        if (regularText == null) {
            return;
        }
        Paragraph p = new Paragraph(true);
        this.paragraphs.add(p);
        int pstart = 0;
        int i = 0;
        while (i < regularText.length()) {
            char c = regularText.charAt(i);
            if (p == null) {
                p = new Paragraph(true);
                this.paragraphs.add(p);
            }
            if (c == '\n') {
                String text = regularText.substring(pstart, i);
                pstart = i + 1;
                p.parseRegularText(text, convertURLs, this.getHyperlinkSettings(), null);
                p = null;
            }
            ++i;
        }
        if (p != null) {
            String text = regularText.substring(pstart);
            p.parseRegularText(text, convertURLs, this.getHyperlinkSettings(), null);
        }
    }

    public HyperlinkSettings getHyperlinkSettings() {
        return this.hyperlinkSettings;
    }

    public void setHyperlinkSettings(HyperlinkSettings settings) {
        this.hyperlinkSettings = settings;
    }

    private void reset() {
        if (this.paragraphs == null) {
            this.paragraphs = new Vector();
        }
        this.paragraphs.clear();
        this.selectedLinkIndex = -1;
        this.hyperlinks = null;
    }

    HyperlinkSegment[] getHyperlinks() {
        if (this.hyperlinks != null || this.paragraphs == null) {
            return this.hyperlinks;
        }
        Vector<ParagraphSegment> result = new Vector<ParagraphSegment>();
        int i = 0;
        while (i < this.paragraphs.size()) {
            Paragraph p = (Paragraph)this.paragraphs.get(i);
            ParagraphSegment[] segments = p.getSegments();
            int j = 0;
            while (j < segments.length) {
                if (segments[j] instanceof HyperlinkSegment) {
                    result.add(segments[j]);
                }
                ++j;
            }
            ++i;
        }
        this.hyperlinks = result.toArray(new HyperlinkSegment[result.size()]);
        return this.hyperlinks;
    }

    public HyperlinkSegment findHyperlinkAt(int x, int y) {
        HyperlinkSegment[] links = this.getHyperlinks();
        int i = 0;
        while (i < links.length) {
            if (links[i].contains(x, y)) {
                return links[i];
            }
            ++i;
        }
        return null;
    }

    public TextSegment findSegmentAt(int x, int y) {
        int i = 0;
        while (i < this.paragraphs.size()) {
            Paragraph p = (Paragraph)this.paragraphs.get(i);
            TextSegment segment = p.findSegmentAt(x, y);
            if (segment != null) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public HyperlinkSegment getSelectedLink() {
        if (this.selectedLinkIndex == -1) {
            return null;
        }
        return this.hyperlinks[this.selectedLinkIndex];
    }

    public boolean traverseLinks(boolean next) {
        HyperlinkSegment[] links = this.getHyperlinks();
        if (links == null) {
            return false;
        }
        int size = links.length;
        this.selectedLinkIndex = next ? ++this.selectedLinkIndex : --this.selectedLinkIndex;
        if (this.selectedLinkIndex < 0 || this.selectedLinkIndex > size - 1) {
            this.selectedLinkIndex = -1;
        }
        return this.selectedLinkIndex != -1;
    }

    public void selectLink(HyperlinkSegment link) {
        if (link == null) {
            this.selectedLinkIndex = -1;
        } else {
            HyperlinkSegment[] links = this.getHyperlinks();
            this.selectedLinkIndex = -1;
            if (links == null) {
                return;
            }
            int i = 0;
            while (i < links.length) {
                if (links[i].equals(link)) {
                    this.selectedLinkIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    public boolean hasFocusSegments() {
        HyperlinkSegment[] links = this.getHyperlinks();
        return links.length > 0;
    }

    public void dispose() {
        this.paragraphs = null;
        this.selectedLinkIndex = -1;
        this.hyperlinks = null;
    }
}

